/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalDateTime", "Ljava/time/LocalDateTime;", "kotlin.jvm.PlatformType", "millis", "", "seconds", "nanos", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
@SourceDebugExtension(value={"SMAP\nJavaDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDateColumnType.kt\norg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1#2:450\n*E\n"})
public final class JavaLocalDateTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateTimeColumnType INSTANCE = new JavaLocalDateTimeColumnType();

    public JavaLocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof LocalDateTime) {
            instant = Instant.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            instant = Instant.ofEpochSecond(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        Instant instant2 = instant;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof SQLiteDialect ? '\'' + JavaDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'' : (dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + JavaDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'' : '\'' + JavaDateColumnTypeKt.getDEFAULT_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'');
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof LocalDateTime) {
            object = value;
        } else if (object2 instanceof Date) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Date)value).getTime());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(...)");
        } else if (object2 instanceof Timestamp) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(...)");
        } else if (object2 instanceof Integer) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Number)value).intValue());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(...)");
        } else if (object2 instanceof Long) {
            LocalDateTime localDateTime = this.longToLocalDateTime(((Number)value).longValue());
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"longToLocalDateTime(...)");
        } else if (object2 instanceof String) {
            LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.formatterForDateString((String)value));
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
        } else if (object2 instanceof OffsetDateTime) {
            LocalDateTime localDateTime = ((OffsetDateTime)value).toLocalDateTime();
            object = localDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        } else {
            object = this.valueFromDB(value.toString());
        }
        return object;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof LocalDateTime && DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = JavaDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(((LocalDateTime)value).atZone(ZoneId.systemDefault()));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (value instanceof LocalDateTime) {
            Timestamp timestamp;
            Instant instant = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
            Timestamp $this$notNullValueToDB_u24lambda_u240 = timestamp = new Timestamp(instant.toEpochMilli());
            boolean bl = false;
            $this$notNullValueToDB_u24lambda_u240.setNanos(instant.getNano());
            object = timestamp;
        } else {
            object = value;
        }
        return object;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    private final LocalDateTime longToLocalDateTime(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

    private final LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), ZoneId.systemDefault());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

