/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

public final class BindListFactory
implements SqlStatementCustomizerFactory {
    private static final String valueNotHandledMessage = "EmptyHandling type on BindList not handled. Please report this to the jdbi developers.";

    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        BindList bindList = (BindList)annotation;
        String name = ParameterUtil.findParameterName(bindList.value(), param).orElseThrow(() -> new UnsupportedOperationException("A @BindList parameter was not given a name, and parameter name data is not present in the class file, for: " + param.getDeclaringExecutable() + "::" + param));
        return (stmt, arg) -> {
            if (arg == null || IterableLike.isEmpty((Object)arg)) {
                switch (bindList.onEmpty()) {
                    case VOID: {
                        stmt.define(name, (Object)"");
                        return;
                    }
                    case NULL: {
                        stmt.define(name, (Object)"null");
                        return;
                    }
                    case THROW: {
                        throw new IllegalArgumentException(arg == null ? "argument is null; null was explicitly forbidden on this instance of BindList" : "argument is empty; emptiness was explicitly forbidden on this instance of BindList");
                    }
                }
                throw new IllegalStateException(valueNotHandledMessage);
            }
            stmt.bindList(name, IterableLike.toList((Object)arg));
        };
    }
}

