/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdbi.v3.core;

import java.sql.Connection;

/**
 * Connection handler which always provides a single connection.  Close operation is ignored.
 */
class SingleConnectionFactory implements ConnectionFactory {

    private final Connection connection;

    SingleConnectionFactory(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection openConnection() {
        return connection;
    }

    @Override
    public void closeConnection(Connection toClose) {}
}
