/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Util;
import org.javalite.conversion.Converter;
import org.javalite.conversion.DateToStringConverter;
import org.javalite.conversion.StringToSqlDateConverter;
import org.javalite.conversion.StringToTimestampConverter;
import org.javalite.validation.AttributePresenceValidator;
import org.javalite.validation.Errors;
import org.javalite.validation.NumericValidationBuilder;
import org.javalite.validation.NumericValidator;
import org.javalite.validation.Validatable;
import org.javalite.validation.ValidationBuilder;
import org.javalite.validation.ValidationException;
import org.javalite.validation.Validator;

public class ValidationSupport
implements Validatable {
    private final Map<String, List<Converter>> attributeConverters = new CaseInsensitiveMap<List<Converter>>();
    private final List<Validator> validators = new ArrayList<Validator>();
    private Errors errors = new Errors();

    public void convertWith(Converter converter, String attribute) {
        this.attributeConverters.computeIfAbsent(attribute, k -> new ArrayList()).add(converter);
    }

    public <S, T> Converter<S, T> converterForClass(String attribute, Class<S> sourceClass, Class<T> destinationClass) {
        List<Converter> list = this.attributeConverters.get(attribute);
        if (list != null) {
            for (Converter converter : list) {
                if (!converter.canConvert(sourceClass, destinationClass)) continue;
                return converter;
            }
        }
        return null;
    }

    public <T> Converter<Object, T> converterForValue(String attribute, Object value, Class<T> destinationClass) {
        return this.converterForClass(attribute, value != null ? value.getClass() : Object.class, destinationClass);
    }

    public ValidationBuilder validateWith(Validator validator) {
        this.validators.add(validator);
        return new ValidationBuilder<Validator>(validator);
    }

    public ValidationBuilder validateWith(List<Validator> list) {
        this.validators.addAll(list);
        return new ValidationBuilder<List<Validator>>(list);
    }

    public NumericValidationBuilder validateNumericalityOf(String ... attributes) {
        ArrayList<NumericValidator> list = new ArrayList<NumericValidator>();
        for (String attribute : attributes) {
            NumericValidator validator = new NumericValidator(attribute);
            list.add(validator);
            this.validators.add(validator);
        }
        return new NumericValidationBuilder((List<NumericValidator>)list);
    }

    public ValidationBuilder validatePresenceOf(String ... attributes) {
        ArrayList<Validator> list = new ArrayList<Validator>();
        for (String attribute : attributes) {
            list.add(new AttributePresenceValidator(attribute));
        }
        return this.validateWith(list);
    }

    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    public List<Validator> validators() {
        return this.validators;
    }

    public void dateFormat(String pattern, String ... attributes) {
        this.dateFormat(new SimpleDateFormat(pattern), attributes);
    }

    public void dateFormat(DateFormat format, String ... attributes) {
        this.convertWith((Converter)new DateToStringConverter(format), attributes);
        this.convertWith((Converter)new StringToSqlDateConverter(format), attributes);
    }

    public void timestampFormat(String pattern, String ... attributes) {
        this.timestampFormat(new SimpleDateFormat(pattern), attributes);
    }

    public void timestampFormat(DateFormat format, String ... attributes) {
        this.convertWith((Converter)new DateToStringConverter(format), attributes);
        this.convertWith((Converter)new StringToTimestampConverter(format), attributes);
    }

    public void convertWith(Converter converter, String ... attributes) {
        for (String attribute : attributes) {
            this.convertWith(converter, attribute);
        }
    }

    @Override
    public Object get(String attributeName) {
        try {
            boolean needRevert = false;
            Field field = Util.getField(attributeName, this.getClass());
            if (!field.isAccessible()) {
                field.setAccessible(true);
                needRevert = true;
            }
            Object value = field.get(this);
            if (needRevert) {
                field.setAccessible(false);
            }
            return value;
        }
        catch (Exception e) {
            throw new ValidationException(this);
        }
    }

    @Override
    public void addFailedValidator(Validator validator, String errorKey) {
        this.errors.addValidator(errorKey, validator);
    }

    @Override
    public boolean isValid() {
        this.validate();
        return this.errors.size() == 0;
    }

    @Override
    public void validate() {
        this.validate(true);
    }

    @Override
    public void validate(boolean reset) {
        if (reset) {
            this.errors = new Errors();
        }
        for (Validator validator : this.validators()) {
            validator.validate(this);
        }
    }

    @Override
    public Errors errors() {
        return this.errors;
    }

    @Override
    public Errors errors(Locale locale) {
        this.errors.setLocale(locale);
        return this.errors;
    }
}

