/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Util;
import org.javalite.validation.Validatable;
import org.javalite.validation.Validator;
import org.javalite.validation.ValidatorAdapter;

public class Errors
implements Map<String, String> {
    private Locale locale;
    private final Map<String, Validator> validators = new CaseInsensitiveMap<Validator>();

    public void addValidator(String attributeName, Validator validator) {
        this.validators.put(attributeName, validator);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String get(Object attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null");
        }
        Validator v = this.validators.get(attributeName);
        return v == null ? null : v.formatMessage(this.locale, new Object[0]);
    }

    public String get(String attributeName, Object ... params) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName cannot be null");
        }
        return this.validators.get(attributeName).formatMessage(this.locale, params);
    }

    @Override
    public int size() {
        return this.validators.size();
    }

    @Override
    public boolean isEmpty() {
        return this.validators.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.validators.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.validators.containsValue(value);
    }

    public String toJSON() {
        ArrayList<CallSite> jsonParts = new ArrayList<CallSite>();
        for (String attribute : this.validators.keySet()) {
            jsonParts.add((CallSite)((Object)("\"" + attribute + "\":\"" + this.validators.get(attribute).formatMessage(null, new Object[0]) + "\"")));
        }
        return "{" + Util.join(jsonParts, ",") + "}";
    }

    @Override
    public String put(String key, String value) {
        NopValidator nv = new NopValidator();
        nv.setMessage(value);
        Validator v = this.validators.put(key, nv);
        return v == null ? null : v.formatMessage(null, new Object[0]);
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.validators.keySet();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> messageList = new ArrayList<String>();
        for (Map.Entry<String, Validator> v : this.validators.entrySet()) {
            messageList.add(v.getValue().formatMessage(this.locale, new Object[0]));
        }
        return messageList;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        LinkedHashSet<Map.Entry<String, String>> entries = new LinkedHashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, Validator> validator : this.validators.entrySet()) {
            String value = validator.getValue().formatMessage(this.locale, new Object[0]);
            entries.add(new ErrorEntry(validator.getKey(), value));
        }
        return entries;
    }

    public String toString() {
        StringBuilder res = new StringBuilder().append("{ ");
        for (Map.Entry<String, Validator> entry : this.validators.entrySet()) {
            res.append(entry.getKey()).append("=<").append(entry.getValue().formatMessage(null, new Object[0])).append("> ");
        }
        res.append('}');
        return res.toString();
    }

    class ErrorEntry
    implements Map.Entry {
        private final String key;
        private final String value;

        ErrorEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    class NopValidator
    extends ValidatorAdapter {
        NopValidator() {
        }

        @Override
        public void validate(Validatable validatable) {
        }
    }
}

