/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.javalite.common.Util;

public class RuntimeUtil {
    public static Response execute(String ... command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            OutputReader stdOutReader = new OutputReader(process.getInputStream());
            OutputReader stdErrReader = new OutputReader(process.getErrorStream());
            Thread t1 = new Thread(stdOutReader);
            t1.start();
            Thread t2 = new Thread(stdErrReader);
            t2.start();
            int code = process.waitFor();
            t1.join();
            t2.join();
            String out = stdOutReader.getOutput();
            String err = stdErrReader.getOutput();
            return new Response(out, err, code);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Response execute(String command) {
        return RuntimeUtil.execute(Util.split(command, " "));
    }

    public static void main(String[] args) {
        System.out.println(RuntimeUtil.execute((String)"ls -ls").out);
        System.out.println(RuntimeUtil.execute((String[])new String[]{"ls", "-ls"}).out);
    }

    static class OutputReader
    implements Runnable {
        private static final int MAX_SIZE = 2048;
        private InputStream is;
        private LinkedList<Character> buffer = new LinkedList();

        OutputReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int s;
                InputStreamReader reader = new InputStreamReader(this.is);
                while ((s = reader.read()) != -1) {
                    if (this.buffer.size() == 2048) {
                        this.buffer.remove(0);
                    }
                    this.buffer.add(Character.valueOf((char)s));
                }
                this.is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String getOutput() {
            StringBuilder stringBuilder = new StringBuilder(this.buffer.size());
            for (Character character : this.buffer) {
                stringBuilder.append(character);
            }
            return stringBuilder.toString();
        }
    }

    public static class Response {
        public final String out;
        public final String err;
        public final int exitValue;

        Response(String out, String err, int exitValue) {
            this.out = out;
            this.err = err;
            this.exitValue = exitValue;
        }
    }
}

