/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.app_config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.javalite.app_config.ConfigInitException;
import org.javalite.app_config.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig
implements Map<String, String> {
    private static Logger LOGGER = LoggerFactory.getLogger(AppConfig.class);
    private static HashMap<String, Property> props = new HashMap();
    private static HashMap<String, String> plainProps = new HashMap();
    private static final String activeEnv;

    public static synchronized void init() {
        if (AppConfig.isInited()) {
            return;
        }
        try {
            String file;
            URL url;
            String activeEnv;
            URL globalUrl = AppConfig.class.getResource("/app_config/global.properties");
            if (globalUrl != null) {
                AppConfig.registerProperties(globalUrl);
            }
            if ((activeEnv = System.getProperty("active_env")) == null) {
                activeEnv = System.getenv("ACTIVE_ENV");
            }
            if (activeEnv == null) {
                LOGGER.warn("Environment variable 'ACTIVE_ENV' not found, defaulting to 'development'");
                activeEnv = "development";
            }
            if ((url = AppConfig.class.getResource(file = "/app_config/" + activeEnv + ".properties")) == null) {
                LOGGER.warn("Property file not found: '" + file + "'");
            } else {
                AppConfig.registerProperties(url);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isInited() {
        return !props.isEmpty();
    }

    private static void registerProperties(URL url) {
        LOGGER.info("Registering properties from: " + url.getPath());
        Properties temp = new Properties();
        try {
            temp.load(url.openStream());
        }
        catch (IOException e) {
            throw new ConfigInitException(e);
        }
        Enumeration<Object> keys = temp.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = temp.getProperty(key);
            Property property = new Property(key, value, url.getPath());
            Property previous = props.put(key, property);
            plainProps.put(key, value);
            if (previous == null) continue;
            LOGGER.warn("\n************************************************************\nDuplicate property defined. Property: '" + key + "' found in files: \n" + previous.getPropertyFile() + ", \n" + url.getPath() + "\nUsing value '" + property.getValue() + "' from:\n" + property.getPropertyFile() + "\n************************************************************");
        }
    }

    public static Property getAsProperty(String key) {
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        return props.get(key);
    }

    public static String getProperty(String key) {
        Property p;
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        return (p = props.get(key)) == null ? null : p.getValue();
    }

    public static String p(String key) {
        return AppConfig.getProperty(key);
    }

    public static Map<String, String> getAllProperties() {
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        return plainProps;
    }

    @Override
    public int size() {
        return props.size();
    }

    @Override
    public boolean isEmpty() {
        return props.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return props.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return AppConfig.p(key.toString());
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    public static String activeEnv() {
        return activeEnv;
    }

    public static boolean isInTestEnv() {
        return "testenv".equals(AppConfig.activeEnv());
    }

    public static boolean isInProduction() {
        return "production".equals(AppConfig.activeEnv());
    }

    public static boolean isInDevelopment() {
        return "development".equals(AppConfig.activeEnv());
    }

    public static boolean isInStaging() {
        return "development".equals(AppConfig.activeEnv());
    }

    public static List<String> getKeys(String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        for (String key : props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            res.add(key);
        }
        return res;
    }

    public static List<String> getProperties(String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        prefix = prefix + ".";
        int i = 1;
        String prop;
        while ((prop = AppConfig.p(prefix + i)) != null) {
            res.add(prop);
            ++i;
        }
        return res;
    }

    static {
        String env = System.getenv("ACTIVE_ENV");
        if (env == null) {
            LOGGER.warn("Environment variable 'ACTIVE_ENV' not found, defaulting to 'development'");
            env = "development";
        }
        activeEnv = env;
        AppConfig.init();
    }
}

