/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.statistics;

import java.util.regex.Pattern;

public class QueryExecutionEvent {
    private static final Pattern IN_PATTERN = Pattern.compile("(IN|in)\\s*\\(.*\\)", 2);
    private static final Pattern OFFSET_PATTERN = Pattern.compile("(offset|OFFSET|Offset)\\s*\\d*", 2);
    private static final Pattern INSERT_INTO_PATTERN = Pattern.compile("INSERT.*into.*VALUES.*", 34);
    private String query;
    private final long time;

    public QueryExecutionEvent(String query, long time) {
        this.query = IN_PATTERN.matcher(query).replaceAll("IN (...)");
        this.query = OFFSET_PATTERN.matcher(this.query).replaceAll("offset ...");
        if (query.contains("TabSeparated")) {
            this.query = query.substring(0, query.indexOf("TabSeparated")) + "...";
        }
        if (INSERT_INTO_PATTERN.matcher(query).matches()) {
            String lowerCase = query.toLowerCase();
            this.query = query.substring(0, lowerCase.indexOf("values")) + " VALUES (...)";
        }
        this.time = time;
    }

    public String getQuery() {
        return this.query;
    }

    public long getTime() {
        return this.time;
    }
}

