/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.javalite.activejdbc.Base;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveJdbcFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveJdbcFilter.class);
    private String jndiName;

    public void init(FilterConfig config) throws ServletException {
        this.jndiName = config.getInitParameter("jndiName");
        if (this.jndiName == null) {
            throw new IllegalArgumentException("must provide jndiName parameter for this filter");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        long before = System.currentTimeMillis();
        try {
            Base.open(this.jndiName);
            Base.openTransaction();
            chain.doFilter(req, resp);
            Base.commitTransaction();
        }
        catch (IOException e) {
            Base.rollbackTransaction();
            throw e;
        }
        catch (ServletException e) {
            Base.rollbackTransaction();
            throw e;
        }
        finally {
            Base.close();
        }
        LOGGER.info("Processing took: {} milliseconds", (Object)(System.currentTimeMillis() - before));
    }

    public void destroy() {
    }
}

