/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.ValidatorAdapter;

public class RegexpValidator
extends ValidatorAdapter {
    private final Pattern pattern;
    private final String attribute;

    public RegexpValidator(String attribute, String rule) {
        this.pattern = Pattern.compile(rule, 2);
        this.attribute = attribute;
        this.setMessage("value does not match given format");
    }

    @Override
    public void validate(Model m) {
        if (m.get(this.attribute) == null) {
            m.addValidator(this, this.attribute);
            return;
        }
        Object value = m.get(this.attribute);
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("attribute " + this.attribute + " is not String");
        }
        Matcher matcher = this.pattern.matcher((String)value);
        if (!matcher.matches()) {
            m.addValidator(this, this.attribute);
        }
    }
}

