/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.CaseInsensitiveSet;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.annotations.Cached;
import org.javalite.activejdbc.annotations.CompositePK;
import org.javalite.activejdbc.annotations.DbName;
import org.javalite.activejdbc.annotations.IdGenerator;
import org.javalite.activejdbc.annotations.IdName;
import org.javalite.activejdbc.annotations.PartitionIDs;
import org.javalite.activejdbc.annotations.Table;
import org.javalite.activejdbc.annotations.VersionColumn;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.activejdbc.dialects.Dialects;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.common.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaModel
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModel.class);
    private static final ThreadLocal<HashMap<Class, String>> shardingTableNamesTL = new ThreadLocal();
    private Map<String, ColumnMetadata> columnMetadata;
    private final List<Association> associations = new ArrayList<Association>();
    private final String idName;
    private final String[] compositeKeys;
    private final String tableName;
    private final String dbType;
    private final String dbName;
    private final Class<? extends Model> modelClass;
    private final boolean cached;
    private final String idGeneratorCode;
    private Set<String> attributeNamesNoId;
    private final String versionColumn;
    private String[] partitionIDs = null;

    protected MetaModel(String dbName, Class<? extends Model> modelClass, String dbType) {
        this.modelClass = modelClass;
        this.idName = this.findIdName(modelClass);
        this.compositeKeys = this.findCompositeKeys(modelClass);
        this.tableName = this.findTableName(modelClass);
        this.dbType = dbType;
        this.cached = this.isCached(modelClass);
        this.dbName = dbName;
        this.idGeneratorCode = this.findIdGeneratorCode(modelClass);
        this.versionColumn = this.findVersionColumn(modelClass);
        this.partitionIDs = this.findPartitionIDs();
    }

    private String[] findPartitionIDs() {
        PartitionIDs partitionIDs = this.modelClass.getAnnotation(PartitionIDs.class);
        return partitionIDs != null ? partitionIDs.value() : null;
    }

    public boolean hasPartitionIDs() {
        return this.partitionIDs != null;
    }

    public String[] getPartitionIDs() {
        return this.partitionIDs;
    }

    static Map<Class, String> getTableNamesMap() {
        if (shardingTableNamesTL.get() == null) {
            shardingTableNamesTL.set(new HashMap());
        }
        return shardingTableNamesTL.get();
    }

    public void setShardTableName(String tableName) {
        MetaModel.getTableNamesMap().put(this.modelClass, tableName);
    }

    public void clearShardTableName() {
        MetaModel.getTableNamesMap().remove(this.modelClass);
    }

    private boolean isCached(Class<? extends Model> modelClass) {
        return null != modelClass.getAnnotation(Cached.class);
    }

    private String findIdName(Class<? extends Model> modelClass) {
        IdName idNameAnnotation = modelClass.getAnnotation(IdName.class);
        return idNameAnnotation == null ? "id" : idNameAnnotation.value();
    }

    private String[] findCompositeKeys(Class<? extends Model> modelClass) {
        CompositePK compositeKeysAnnotation = modelClass.getAnnotation(CompositePK.class);
        return compositeKeysAnnotation == null ? null : compositeKeysAnnotation.value();
    }

    private String findTableName(Class<? extends Model> modelClass) {
        Table tableAnnotation = modelClass.getAnnotation(Table.class);
        return tableAnnotation == null ? Inflector.tableize((String)modelClass.getSimpleName()) : tableAnnotation.value();
    }

    private String findIdGeneratorCode(Class<? extends Model> modelClass) {
        IdGenerator idGenerator = modelClass.getAnnotation(IdGenerator.class);
        return idGenerator == null ? null : idGenerator.value();
    }

    private String findVersionColumn(Class<? extends Model> modelClass) {
        VersionColumn vc = modelClass.getAnnotation(VersionColumn.class);
        return vc == null ? "record_version" : vc.value();
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public String getIdGeneratorCode() {
        return this.idGeneratorCode;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean cached() {
        return this.cached;
    }

    public Class<? extends Model> getModelClass() {
        return this.modelClass;
    }

    public String getTableName() {
        if (MetaModel.getTableNamesMap().containsKey(this.modelClass)) {
            return MetaModel.getTableNamesMap().get(this.modelClass);
        }
        return this.tableName;
    }

    void setColumnMetadata(Map<String, ColumnMetadata> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    protected boolean tableExists() {
        return this.columnMetadata != null && this.columnMetadata.isEmpty();
    }

    public Set<String> getAttributeNamesSkipId() {
        if (this.attributeNamesNoId == null) {
            CaseInsensitiveSet attributesNames = new CaseInsensitiveSet((Collection<? extends String>)this.getAttributeNames());
            attributesNames.remove(this.getIdName());
            this.attributeNamesNoId = attributesNames;
        }
        return this.attributeNamesNoId;
    }

    public Set<String> getAttributeNamesSkipGenerated() {
        return this.getAttributeNamesSkipGenerated(true);
    }

    public Set<String> getAttributeNamesSkipGenerated(boolean managed) {
        CaseInsensitiveSet attributesNames = new CaseInsensitiveSet((Collection<? extends String>)this.getAttributeNamesSkipId());
        if (managed) {
            attributesNames.remove("created_at");
            attributesNames.remove("updated_at");
        }
        attributesNames.remove(this.versionColumn);
        return attributesNames;
    }

    public Set<String> getAttributeNamesSkip(String ... names) {
        CaseInsensitiveSet attributes = new CaseInsensitiveSet((Collection<? extends String>)this.getAttributeNames());
        for (String name : names) {
            attributes.remove(name);
        }
        return attributes;
    }

    public boolean isVersioned() {
        return this.columnMetadata != null && this.columnMetadata.containsKey(this.versionColumn);
    }

    protected Set<String> getAttributeNames() {
        if (this.columnMetadata == null || this.columnMetadata.isEmpty()) {
            throw new InitException("Failed to find table: " + this.getTableName());
        }
        return Collections.unmodifiableSet(this.columnMetadata.keySet());
    }

    public String getIdName() {
        return this.idName;
    }

    public String[] getCompositeKeys() {
        return this.compositeKeys;
    }

    public <A extends Association> A getAssociationForTarget(Class<? extends Model> targetModelClass, Class<A> associationClass) {
        Association result = null;
        for (Association association : this.associations) {
            if (!association.getClass().getName().equals(associationClass.getName()) || !association.getTargetClass().getName().equals(targetModelClass.getName())) continue;
            result = association;
            break;
        }
        return (A)result;
    }

    public <A extends Association> A getAssociationForTarget(Class<? extends Model> targetClass) {
        Association result = null;
        for (Association association : this.associations) {
            if (!association.getTargetClass().getName().equals(targetClass.getName())) continue;
            result = association;
            break;
        }
        return (A)result;
    }

    public List<Association> getAssociationsForTarget(Class<? extends Model> targetModelClass) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association association : this.associations) {
            if (!association.getTargetClass().getName().equals(targetModelClass.getName())) continue;
            result.add(association);
        }
        return result;
    }

    protected void addAssociation(Association association) {
        if (!this.associations.contains(association)) {
            LogFilter.log(LOGGER, LogLevel.INFO, "Association found: {}", (Object)association);
            this.associations.add(association);
        }
    }

    boolean hasAttribute(String attribute) {
        if (this.columnMetadata != null) {
            if (this.columnMetadata.containsKey(attribute)) {
                return true;
            }
            if (attribute.startsWith("\"") && attribute.endsWith("\"")) {
                return this.columnMetadata.containsKey(attribute.substring(1, attribute.length() - 1));
            }
        }
        return false;
    }

    protected boolean hasAssociation(Class<? extends Model> targetClass, Class<? extends Association> associationClass) {
        for (Association association : this.associations) {
            if (!association.getTargetClass().getName().equals(targetClass.getName()) || !association.getClass().getName().equals(associationClass.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder t = new StringBuilder();
        t.append("MetaModel: ").append(this.tableName).append(", ").append(this.modelClass).append("\n");
        if (this.columnMetadata != null) {
            for (Map.Entry<String, ColumnMetadata> metadata : this.columnMetadata.entrySet()) {
                t.append(metadata.getValue()).append(", ");
            }
        }
        return t.toString();
    }

    public String getFKName() {
        return Inflector.singularize((String)this.getTableName()).toLowerCase() + "_id";
    }

    protected List<OneToManyAssociation> getOneToManyAssociations(List<Association> exclusions) {
        ArrayList<OneToManyAssociation> one2Manies = new ArrayList<OneToManyAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(OneToManyAssociation.class) || exclusions.contains(association)) continue;
            one2Manies.add((OneToManyAssociation)association);
        }
        return one2Manies;
    }

    protected List<OneToManyPolymorphicAssociation> getPolymorphicAssociations(List<Association> exclusions) {
        ArrayList<OneToManyPolymorphicAssociation> one2Manies = new ArrayList<OneToManyPolymorphicAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(OneToManyPolymorphicAssociation.class) || exclusions.contains(association)) continue;
            one2Manies.add((OneToManyPolymorphicAssociation)association);
        }
        return one2Manies;
    }

    protected List<Many2ManyAssociation> getManyToManyAssociations(List<Association> excludedAssociations) {
        ArrayList<Many2ManyAssociation> many2Manies = new ArrayList<Many2ManyAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(Many2ManyAssociation.class) || excludedAssociations.contains(association)) continue;
            many2Manies.add((Many2ManyAssociation)association);
        }
        return many2Manies;
    }

    public String getDbType() {
        return this.dbType;
    }

    public Dialect getDialect() {
        return Dialects.getDialect(this.dbType);
    }

    protected List<Association> getAssociations() {
        return Collections.unmodifiableList(this.associations);
    }

    protected void checkAttribute(String attribute) {
        if (!this.hasAttribute(attribute)) {
            String sb = "Attribute: '" + attribute + "' is not defined in model: '" + this.getModelClass() + ". Available attributes: " + this.getAttributeNames();
            throw new IllegalArgumentException(sb);
        }
    }

    protected static String getDbName(Class<? extends Model> modelClass) {
        DbName dbNameAnnotation = modelClass.getAnnotation(DbName.class);
        return dbNameAnnotation == null ? "default" : dbNameAnnotation.value();
    }

    public Map<String, ColumnMetadata> getColumnMetadata() {
        if (this.columnMetadata == null || this.columnMetadata.isEmpty()) {
            throw new InitException("Failed to find table: " + this.getTableName());
        }
        return Collections.unmodifiableMap(this.columnMetadata);
    }

    public boolean isAssociatedTo(Class<? extends Model> targetModelClass) {
        if (targetModelClass == null) {
            throw new NullPointerException();
        }
        for (Association association : this.associations) {
            if (!association.getTargetClass().getName().equals(targetModelClass.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeAssociationForTarget(Class<? extends Model> modelClass) {
        Object association = this.getAssociationForTarget(modelClass);
        if (association != null) {
            this.associations.remove(association);
        }
    }
}

