/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.resolver.wrapper;

import java.lang.reflect.Method;
import org.inventivetalent.reflection.resolver.wrapper.WrapperAbstract;

public class MethodWrapper<R>
extends WrapperAbstract {
    private final Method method;

    public MethodWrapper(Method method) {
        this.method = method;
    }

    @Override
    public boolean exists() {
        return this.method != null;
    }

    public String getName() {
        return this.method.getName();
    }

    public R invoke(Object object, Object ... args) {
        try {
            return (R)this.method.invoke(object, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public R invokeSilent(Object object, Object ... args) {
        try {
            return (R)this.method.invoke(object, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MethodWrapper that = (MethodWrapper)object;
        return this.method != null ? this.method.equals(that.method) : that.method == null;
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }
}

