/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.inventivetalent.reflection.annotation.Class;
import org.inventivetalent.reflection.annotation.Field;
import org.inventivetalent.reflection.annotation.Method;
import org.inventivetalent.reflection.minecraft.Minecraft;
import org.inventivetalent.reflection.resolver.ClassResolver;
import org.inventivetalent.reflection.resolver.FieldResolver;
import org.inventivetalent.reflection.resolver.MethodResolver;
import org.inventivetalent.reflection.resolver.wrapper.ClassWrapper;
import org.inventivetalent.reflection.resolver.wrapper.FieldWrapper;
import org.inventivetalent.reflection.resolver.wrapper.MethodWrapper;

public class ReflectionAnnotations {
    public static final ReflectionAnnotations INSTANCE = new ReflectionAnnotations();
    static final Pattern classRefPattern = Pattern.compile("@Class\\((.*)\\)");

    private ReflectionAnnotations() {
    }

    public void load(Object toLoad) {
        if (toLoad == null) {
            throw new IllegalArgumentException("toLoad cannot be null");
        }
        ClassResolver classResolver = new ClassResolver();
        for (java.lang.reflect.Field field : toLoad.getClass().getDeclaredFields()) {
            String[] names;
            List<String> nameList;
            Class classAnnotation = field.getAnnotation(Class.class);
            Field fieldAnnotation = field.getAnnotation(Field.class);
            Method methodAnnotation = field.getAnnotation(Method.class);
            if (classAnnotation == null && fieldAnnotation == null && methodAnnotation == null) continue;
            field.setAccessible(true);
            if (classAnnotation != null) {
                nameList = this.parseAnnotationVersions(Class.class, classAnnotation);
                names = nameList.toArray(new String[nameList.size()]);
                for (int i = 0; i < names.length; ++i) {
                    names[i] = names[i].replace("{nms}", "net.minecraft.server." + Minecraft.VERSION.name()).replace("{obc}", "org.bukkit.craftbukkit." + Minecraft.VERSION.name());
                }
                try {
                    if (ClassWrapper.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, classResolver.resolveWrapper(names));
                        continue;
                    }
                    if (java.lang.Class.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, classResolver.resolve(names));
                        continue;
                    }
                    this.throwInvalidFieldType(field, toLoad, "Class or ClassWrapper");
                    return;
                }
                catch (ReflectiveOperationException e) {
                    if (classAnnotation.ignoreExceptions()) continue;
                    this.throwReflectionException("@Class", field, toLoad, e);
                    return;
                }
            }
            if (fieldAnnotation != null) {
                nameList = this.parseAnnotationVersions(Field.class, fieldAnnotation);
                names = nameList.toArray(new String[nameList.size()]);
                try {
                    FieldResolver fieldResolver = new FieldResolver(this.parseClass(Field.class, fieldAnnotation, toLoad));
                    if (FieldWrapper.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, fieldResolver.resolveWrapper(names));
                        continue;
                    }
                    if (java.lang.reflect.Field.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, fieldResolver.resolve(names));
                        continue;
                    }
                    this.throwInvalidFieldType(field, toLoad, "Field or FieldWrapper");
                    return;
                }
                catch (ReflectiveOperationException e) {
                    if (fieldAnnotation.ignoreExceptions()) continue;
                    this.throwReflectionException("@Field", field, toLoad, e);
                    return;
                }
            }
            if (methodAnnotation == null) continue;
            nameList = this.parseAnnotationVersions(Method.class, methodAnnotation);
            names = nameList.toArray(new String[nameList.size()]);
            try {
                MethodResolver methodResolver = new MethodResolver(this.parseClass(Method.class, methodAnnotation, toLoad));
                if (MethodWrapper.class.isAssignableFrom(field.getType())) {
                    field.set(toLoad, methodResolver.resolveWrapper(names));
                    continue;
                }
                if (java.lang.reflect.Method.class.isAssignableFrom(field.getType())) {
                    field.set(toLoad, methodResolver.resolve(names));
                    continue;
                }
                this.throwInvalidFieldType(field, toLoad, "Method or MethodWrapper");
                return;
            }
            catch (ReflectiveOperationException e) {
                if (methodAnnotation.ignoreExceptions()) continue;
                this.throwReflectionException("@Method", field, toLoad, e);
                return;
            }
        }
    }

    <A extends Annotation> List<String> parseAnnotationVersions(java.lang.Class<A> clazz, A annotation) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] names = (String[])clazz.getMethod("value", new java.lang.Class[0]).invoke(annotation, new Object[0]);
            Minecraft.Version[] versions = (Minecraft.Version[])clazz.getMethod("versions", new java.lang.Class[0]).invoke(annotation, new Object[0]);
            if (versions.length == 0) {
                for (String name : names) {
                    list.add(name);
                }
            } else {
                if (versions.length > names.length) {
                    throw new RuntimeException("versions array cannot have more elements than the names (" + clazz + ")");
                }
                for (int i = 0; i < versions.length; ++i) {
                    if (Minecraft.VERSION == versions[i]) {
                        list.add(names[i]);
                        continue;
                    }
                    if (names[i].startsWith(">") && Minecraft.VERSION.newerThan(versions[i])) {
                        list.add(names[i].substring(1));
                        continue;
                    }
                    if (!names[i].startsWith("<") || !Minecraft.VERSION.olderThan(versions[i])) continue;
                    list.add(names[i].substring(1));
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    <A extends Annotation> String parseClass(java.lang.Class<A> clazz, A annotation, Object toLoad) {
        try {
            String className = (String)clazz.getMethod("className", new java.lang.Class[0]).invoke(annotation, new Object[0]);
            Matcher matcher = classRefPattern.matcher(className);
            while (matcher.find()) {
                if (matcher.groupCount() != 1) continue;
                String fieldName = matcher.group(1);
                java.lang.reflect.Field field = toLoad.getClass().getField(fieldName);
                if (ClassWrapper.class.isAssignableFrom(field.getType())) {
                    return ((ClassWrapper)field.get(toLoad)).getName();
                }
                if (!java.lang.Class.class.isAssignableFrom(field.getType())) continue;
                return ((java.lang.Class)field.get(toLoad)).getName();
            }
            return className;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    void throwInvalidFieldType(java.lang.reflect.Field field, Object toLoad, String expected) {
        throw new IllegalArgumentException("Field " + field.getName() + " in " + toLoad.getClass() + " is not of type " + expected + ", it's " + field.getType());
    }

    void throwReflectionException(String annotation, java.lang.reflect.Field field, Object toLoad, ReflectiveOperationException exception) {
        throw new RuntimeException("Failed to set " + annotation + " field " + field.getName() + " in " + toLoad.getClass(), exception);
    }
}

