/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.pluginannotations.config;

import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.inventivetalent.pluginannotations.AnnotationsAbstract;
import org.inventivetalent.pluginannotations.config.ConfigValue;

public class ConfigAnnotations
extends AnnotationsAbstract {
    public ConfigAnnotations loadValues(Plugin plugin, Object ... classesToLoad) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        if (classesToLoad.length == 0) {
            throw new IllegalArgumentException("classes cannot be empty");
        }
        for (Object toLoad : classesToLoad) {
            this.loadValues(plugin, toLoad);
        }
        return this;
    }

    public ConfigAnnotations loadValues(Plugin plugin, Object classToLoad) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        if (classToLoad == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        Class<?> clazz = classToLoad.getClass();
        FileConfiguration config = plugin.getConfig();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                ConfigValue annotation = field.getAnnotation(ConfigValue.class);
                if (annotation == null) continue;
                field.setAccessible(true);
                if (config.contains(annotation.path())) {
                    Object value = config.get(annotation.path());
                    if (annotation.colorChar() != ' ') {
                        if (value instanceof String) {
                            value = ChatColor.translateAlternateColorCodes((char)annotation.colorChar(), (String)((String)value));
                        }
                        if (value instanceof List) {
                            ListIterator<String> iterator = ((List)value).listIterator();
                            while (iterator.hasNext()) {
                                Object next = iterator.next();
                                if (!(next instanceof String)) continue;
                                iterator.set(ChatColor.translateAlternateColorCodes((char)annotation.colorChar(), (String)((String)next)));
                            }
                        }
                    }
                    field.set(classToLoad, value);
                    continue;
                }
                if (annotation.defaultsTo().isEmpty()) continue;
                field.set(classToLoad, annotation.defaultsTo());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set config value for field '" + field.getName() + "' in " + clazz, e);
            }
        }
        return this;
    }

    @Override
    public void load(Plugin plugin, Object clazz) {
        this.loadValues(plugin, clazz);
    }
}

