/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.pluginannotations.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.inventivetalent.pluginannotations.AccessUtil;
import org.inventivetalent.pluginannotations.command.Command;
import org.inventivetalent.pluginannotations.command.CommandErrorHandler;
import org.inventivetalent.pluginannotations.command.Completion;
import org.inventivetalent.pluginannotations.command.JoinedArg;
import org.inventivetalent.pluginannotations.command.OptionalArg;
import org.inventivetalent.pluginannotations.command.Permission;
import org.inventivetalent.pluginannotations.command.exception.ArgumentParseException;
import org.inventivetalent.pluginannotations.command.exception.CommandException;
import org.inventivetalent.pluginannotations.command.exception.IllegalSenderException;
import org.inventivetalent.pluginannotations.command.exception.InvalidLengthException;
import org.inventivetalent.pluginannotations.command.exception.PermissionException;
import org.inventivetalent.pluginannotations.command.exception.UnhandledCommandException;

public class AnnotatedCommand {
    private final Object commandClass;
    private final Method commandMethod;
    private final Command commandAnnotation;
    private final Permission permissionAnnotation;
    private final Method completionMethod;
    private final Completion completionAnnotation;
    private final CommandErrorHandler errorHandler;
    public String name = "";
    public String[] aliases = new String[0];
    public String usage = "";
    public String description = "";
    public String permission = "";
    public String permissionMessage = "";
    public String fallbackPrefix = "";
    private BukkitCommand theCommand;
    private CommandMap commandMap;

    public AnnotatedCommand(@Nonnull Object commandClass, @Nonnull Method commandMethod, @Nonnull Command commandAnnotation, @Nullable Permission permissionAnnotation, @Nullable Method completionMethod, @Nullable Completion completionAnnotation) {
        this.commandClass = commandClass;
        this.commandMethod = commandMethod;
        this.commandAnnotation = commandAnnotation;
        this.permissionAnnotation = permissionAnnotation;
        this.completionMethod = completionMethod;
        this.completionAnnotation = completionAnnotation;
        this.name = commandAnnotation.name() != null && !commandAnnotation.name().isEmpty() ? commandAnnotation.name() : commandMethod.getName();
        this.aliases = commandAnnotation.aliases();
        this.usage = commandAnnotation.usage();
        this.description = commandAnnotation.description();
        this.fallbackPrefix = commandAnnotation.fallbackPrefix();
        if (commandAnnotation.errorHandler() != null) {
            try {
                this.errorHandler = commandAnnotation.errorHandler().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.errorHandler = null;
        }
        if (permissionAnnotation != null) {
            if (permissionAnnotation.value() != null && !permissionAnnotation.value().isEmpty()) {
                this.permission = permissionAnnotation.value();
            }
            if (permissionAnnotation.permissionMessage() != null && !permissionAnnotation.permissionMessage().isEmpty()) {
                this.permissionMessage = permissionAnnotation.permissionMessage();
            }
        }
    }

    boolean onCommand(CommandSender sender, BukkitCommand command, String label, String[] args) {
        try {
            if (!this.hasPermission(sender)) {
                throw new PermissionException(this.permission);
            }
            if (args.length < this.commandAnnotation.min()) {
                throw new InvalidLengthException(this.commandAnnotation.min(), args.length);
            }
            if (this.commandAnnotation.max() != -1 && args.length > this.commandAnnotation.max()) {
                throw new InvalidLengthException(this.commandAnnotation.max(), args.length);
            }
            try {
                int i;
                Class<?>[] parameterTypes = this.commandMethod.getParameterTypes();
                if (parameterTypes.length == 0) {
                    throw new CommandException("Command method '" + this.commandMethod.getName() + " in " + this.commandClass + " is missing the CommandSender parameter");
                }
                if (!CommandSender.class.isAssignableFrom(parameterTypes[0])) {
                    throw new CommandException("First parameter of method '" + this.commandMethod.getName() + " in " + this.commandClass + " is no CommandSender");
                }
                if (Player.class.isAssignableFrom(parameterTypes[0]) && !(sender instanceof Player)) {
                    throw new IllegalSenderException();
                }
                if (parameterTypes.length - 1 < this.commandAnnotation.min() || this.commandAnnotation.max() != -1 && parameterTypes.length - 1 > this.commandAnnotation.max()) {
                    throw new CommandException("Parameter length of method '" + this.commandMethod.getName() + " in " + this.commandClass + " is not in the specified argument length range");
                }
                Object[] parsedArguments = new Object[parameterTypes.length];
                for (i = 1; i < args.length + 1; ++i) {
                    if (i == parameterTypes.length - 1) {
                        JoinedArg joinedAnnotation = this.getMethodParameterAnnotation(this.commandMethod, parameterTypes.length - 1, JoinedArg.class);
                        if (joinedAnnotation != null) {
                            parsedArguments[parsedArguments.length - 1] = this.joinArguments(args, i - 1, joinedAnnotation.joiner());
                            break;
                        }
                        if (String[].class.isAssignableFrom(parameterTypes[parameterTypes.length - 1])) {
                            parsedArguments[parsedArguments.length - 1] = this.getLeftoverArguments(args, i - 1);
                            break;
                        }
                    }
                    if (i >= parsedArguments.length) break;
                    parsedArguments[i] = this.parseArgument(parameterTypes[i], args[i - 1]);
                }
                parsedArguments[0] = sender;
                if (parameterTypes.length - 1 > args.length) {
                    for (i = args.length; i < parameterTypes.length; ++i) {
                        OptionalArg optionalAnnotation;
                        if (parsedArguments[i] != null || (optionalAnnotation = this.getMethodParameterAnnotation(this.commandMethod, i, OptionalArg.class)) == null || optionalAnnotation.def() == null || optionalAnnotation.def().isEmpty()) continue;
                        parsedArguments[i] = this.parseArgument(parameterTypes[i], optionalAnnotation.def());
                    }
                }
                this.commandMethod.invoke(this.commandClass, parsedArguments);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CommandException) {
                    throw (CommandException)cause;
                }
                throw new UnhandledCommandException("Unhandled exception while invoking command method in " + this.commandClass + "#" + this.commandMethod.getName(), cause);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Throwable throwable) {
                throw new UnhandledCommandException("Unhandled exception in " + this.commandClass + "#" + this.commandMethod.getName(), throwable);
            }
            return true;
        }
        catch (PermissionException permissionException) {
            if (this.errorHandler != null) {
                this.errorHandler.handlePermissionException(permissionException, sender, command, args);
                return false;
            }
            throw permissionException;
        }
        catch (IllegalSenderException illegalSenderException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleIllegalSender(illegalSenderException, sender, command, args);
                return false;
            }
        }
        catch (ArgumentParseException parseException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleArgumentParse(parseException, sender, command, args);
                return false;
            }
            throw parseException;
        }
        catch (InvalidLengthException lengthException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleLength(lengthException, sender, command, args);
                return false;
            }
            throw lengthException;
        }
        catch (UnhandledCommandException unhandledException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleUnhandled(unhandledException, sender, command, args);
            }
            throw unhandledException;
        }
        catch (CommandException commandException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleCommandException(commandException, sender, command, args);
                return false;
            }
            throw commandException;
        }
        return false;
    }

    <A extends Annotation> A getMethodParameterAnnotation(Method method, int index, Class<A> clazz) {
        Annotation[] annotations = method.getParameterAnnotations()[index];
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!clazz.isAssignableFrom(annotation.getClass())) continue;
                return (A)annotation;
            }
        }
        return null;
    }

    <A extends Annotation> A getMethodParameterAnnotation(Method method, Class<A> clazz) {
        Annotation[][] annotations;
        Annotation[][] annotationArray = annotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotationA;
            for (Annotation annotation : annotationA = annotationArray[i]) {
                if (!clazz.isAssignableFrom(annotation.getClass())) continue;
                return (A)annotation;
            }
        }
        return null;
    }

    List<String> onTabComplete(CommandSender sender, BukkitCommand command, String label, String[] args) {
        if (this.completionAnnotation == null || this.completionMethod == null) {
            return null;
        }
        if (!this.hasPermission(sender)) {
            return null;
        }
        try {
            Class<?>[] parameterTypes = this.completionMethod.getParameterTypes();
            if (parameterTypes.length <= 1) {
                throw new CommandException("Completion method '" + this.completionMethod.getName() + " in " + this.commandClass + " is missing the List or CommandSender parameter");
            }
            if (!List.class.isAssignableFrom(parameterTypes[0])) {
                throw new CommandException("First parameter of method '" + this.completionMethod.getName() + " in " + this.completionMethod + " is no List");
            }
            if (!CommandSender.class.isAssignableFrom(parameterTypes[1])) {
                throw new CommandException("Second parameter of method '" + this.completionMethod.getName() + " in " + this.completionMethod + " is no CommandSender");
            }
            if (Player.class.isAssignableFrom(parameterTypes[0]) && !(sender instanceof Player)) {
                return null;
            }
            Object[] parsedArguments = new Object[parameterTypes.length];
            for (int i = 2; i < args.length + 2; ++i) {
                if (i == parameterTypes.length - 1) {
                    JoinedArg joinedAnnotation = this.getMethodParameterAnnotation(this.completionMethod, parameterTypes.length - 1, JoinedArg.class);
                    if (joinedAnnotation != null) {
                        parsedArguments[parsedArguments.length - 1] = this.joinArguments(args, i - 1, joinedAnnotation.joiner());
                        break;
                    }
                    if (String[].class.isAssignableFrom(parameterTypes[parameterTypes.length - 1])) {
                        parsedArguments[parsedArguments.length - 1] = this.getLeftoverArguments(args, i - 1);
                        break;
                    }
                }
                if (i >= parsedArguments.length) break;
                if (args[i - 2] == null || args[i - 2].isEmpty()) {
                    parsedArguments[i] = null;
                    continue;
                }
                try {
                    parsedArguments[i] = this.parseArgument(parameterTypes[i], args[i - 2]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            parsedArguments[0] = new ArrayList();
            List list = parsedArguments[0];
            parsedArguments[1] = sender;
            this.completionMethod.invoke(this.commandClass, parsedArguments);
            return AnnotatedCommand.getPossibleCompletionsForGivenArgs(args, list.toArray(new String[list.size()]));
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Throwable throwable) {
            throw new UnhandledCommandException("Unhandled exception in " + this.commandClass + "#" + this.completionMethod.getName(), throwable);
        }
    }

    public static List<String> getPossibleCompletionsForGivenArgs(String[] args, String[] possibilities) {
        String argumentToFindCompletionFor = args[args.length - 1];
        ArrayList<String> listOfPossibleCompletions = new ArrayList<String>();
        for (int i = 0; i < possibilities.length; ++i) {
            try {
                if (possibilities[i] == null || !possibilities[i].regionMatches(true, 0, argumentToFindCompletionFor, 0, argumentToFindCompletionFor.length())) continue;
                listOfPossibleCompletions.add(possibilities[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Collections.sort(listOfPossibleCompletions);
        return listOfPossibleCompletions;
    }

    boolean hasPermission(CommandSender sender) {
        return this.permissionAnnotation == null || sender.hasPermission(this.permission);
    }

    Object parseArgument(Class<?> parameterType, String argument) {
        try {
            if (String.class.isAssignableFrom(parameterType)) {
                return argument;
            }
            try {
                Constructor<?> stringConstructor = parameterType.getConstructor(String.class);
                if (stringConstructor != null) {
                    return stringConstructor.newInstance(argument);
                }
            }
            catch (NoSuchMethodException stringConstructor) {
                // empty catch block
            }
            if (Number.class.isAssignableFrom(parameterType)) {
                String parseName = parameterType.getSimpleName();
                if (Integer.class.equals(parameterType)) {
                    parseName = "Int";
                }
                return parameterType.getDeclaredMethod("parse" + parseName, String.class).invoke(null, argument);
            }
            if (Enum.class.isAssignableFrom(parameterType)) {
                try {
                    return Enum.valueOf(parameterType, argument.toUpperCase());
                }
                catch (Exception parseName) {
                    // empty catch block
                }
            }
            throw new ArgumentParseException("Failed to parse argument '" + argument + "' to " + parameterType, argument, parameterType);
        }
        catch (ReflectiveOperationException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof NumberFormatException) {
                throw new ArgumentParseException("Could not parse number " + argument, argument, parameterType);
            }
            throw new ArgumentParseException("Exception while parsing argument '" + argument + "' to " + parameterType, (Throwable)e, argument, parameterType);
        }
    }

    String joinArguments(String[] args, int start, String joiner) {
        if (start > args.length) {
            throw new IllegalArgumentException("start > length");
        }
        StringBuilder joined = new StringBuilder();
        for (int i = start; i < args.length; ++i) {
            if (i != start) {
                joined.append(joiner);
            }
            joined.append(args[i]);
        }
        return joined.toString();
    }

    String[] getLeftoverArguments(String[] args, int start) {
        String[] newArray = new String[args.length - start];
        for (int i = start; i < args.length; ++i) {
            newArray[i - start] = args[i];
        }
        return newArray;
    }

    public final AnnotatedCommand register() {
        BukkitCommand command;
        this.theCommand = command = new BukkitCommand(this.name);
        if (this.description != null) {
            command.setDescription(this.description);
        }
        if (this.usage != null) {
            command.setUsage(this.usage);
        }
        if (this.permission != null) {
            command.setPermission(this.permission);
        }
        if (this.permissionMessage != null) {
            command.setPermissionMessage(this.permissionMessage);
        }
        if (this.aliases.length != 0) {
            ArrayList<String> aliasList = new ArrayList<String>();
            for (String s : this.aliases) {
                aliasList.add(s.toLowerCase());
            }
            command.setAliases(aliasList);
        }
        this.getCommandMap().register(this.fallbackPrefix != null ? this.fallbackPrefix : "", (org.bukkit.command.Command)command);
        return command.executor = this;
    }

    private CommandMap getCommandMap() {
        if (this.commandMap == null) {
            try {
                this.commandMap = (CommandMap)AccessUtil.setAccessible(Bukkit.getServer().getClass().getDeclaredField("commandMap")).get(Bukkit.getServer());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.commandMap;
    }

    private class BukkitCommand
    extends org.bukkit.command.Command {
        private AnnotatedCommand executor;

        protected BukkitCommand(String name) {
            super(name);
        }

        public final boolean execute(CommandSender sender, String label, String[] args) {
            if (this.executor != null) {
                return this.executor.onCommand(sender, this, label, args);
            }
            return false;
        }

        public final List<String> tabComplete(CommandSender sender, String label, String[] args) throws IllegalArgumentException {
            if (this.executor != null) {
                return this.executor.onTabComplete(sender, this, label, args);
            }
            return null;
        }
    }
}

