/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.resolver.wrapper;

import java.lang.reflect.Constructor;

public class ConstructorWrapper<T> {
    private final Constructor<T> constructor;

    public ConstructorWrapper(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public T newInstance(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T newInstanceSilent(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class<?>[] getParameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConstructorWrapper that = (ConstructorWrapper)object;
        return this.constructor != null ? this.constructor.equals(that.constructor) : that.constructor == null;
    }

    public int hashCode() {
        return this.constructor != null ? this.constructor.hashCode() : 0;
    }
}

