/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.minecraft;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.inventivetalent.reflection.resolver.minecraft.OBCClassResolver;
import org.inventivetalent.reflection.util.AccessUtil;

public class Minecraft {
    public static final Version VERSION;
    private static OBCClassResolver obcClassResolver;
    private static Class<?> CraftEntity;

    public static String getVersion() {
        return VERSION.name() + ".";
    }

    public static Object getHandle(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        try {
            method = AccessUtil.setAccessible(object.getClass().getDeclaredMethod("getHandle", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            method = AccessUtil.setAccessible(CraftEntity.getDeclaredMethod("getHandle", new Class[0]));
        }
        return method.invoke(object, new Object[0]);
    }

    public static Entity getBukkitEntity(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        try {
            method = AccessUtil.setAccessible(object.getClass().getDeclaredMethod("getBukkitEntity", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            method = AccessUtil.setAccessible(CraftEntity.getDeclaredMethod("getHandle", new Class[0]));
        }
        return (Entity)method.invoke(object, new Object[0]);
    }

    public static Object getHandleSilent(Object object) {
        try {
            return Minecraft.getHandle(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        obcClassResolver = new OBCClassResolver();
        VERSION = Version.getVersion();
        System.out.println("[ReflectionHelper] Version is " + (Object)((Object)VERSION));
        try {
            CraftEntity = obcClassResolver.resolve("entity.CraftEntity");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Version {
        UNKNOWN(-1){

            @Override
            public boolean matchesPackageName(String packageName) {
                return false;
            }
        }
        ,
        v1_7_R1(10701),
        v1_7_R2(10702),
        v1_7_R3(10703),
        v1_7_R4(10704),
        v1_8_R1(10801),
        v1_8_R2(10802),
        v1_8_R3(10803),
        v1_8_R4(10804),
        v1_9_R1(109001);

        private int version;

        private Version(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }

        public boolean olderThan(Version version) {
            return this.version() < version.version();
        }

        public boolean newerThan(Version version) {
            return this.version() >= version.version();
        }

        public boolean inRange(Version oldVersion, Version newVersion) {
            return this.newerThan(oldVersion) && this.olderThan(newVersion);
        }

        public boolean matchesPackageName(String packageName) {
            return packageName.toLowerCase().contains(this.name().toLowerCase());
        }

        public static Version getVersion() {
            String name = Bukkit.getServer().getClass().getPackage().getName();
            String versionPackage = name.substring(name.lastIndexOf(46) + 1) + ".";
            for (Version version : Version.values()) {
                if (!version.matchesPackageName(versionPackage)) continue;
                return version;
            }
            System.err.println("[ReflectionHelper] Failed to find version enum for '" + name + "'/'" + versionPackage + "'");
            return UNKNOWN;
        }

        public String toString() {
            return this.name() + " (" + this.version() + ")";
        }
    }
}

