/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.minecraft;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nullable;
import org.inventivetalent.reflection.minecraft.Minecraft;
import org.inventivetalent.reflection.resolver.ClassResolver;
import org.inventivetalent.reflection.resolver.ConstructorResolver;
import org.inventivetalent.reflection.resolver.FieldResolver;
import org.inventivetalent.reflection.resolver.MethodResolver;
import org.inventivetalent.reflection.resolver.ResolverQuery;
import org.inventivetalent.reflection.resolver.minecraft.NMSClassResolver;

public class DataWatcher {
    static ClassResolver classResolver = new ClassResolver();
    static NMSClassResolver nmsClassResolver = new NMSClassResolver();
    static Class<?> ItemStack = nmsClassResolver.resolveSilent("ItemStack");
    static Class<?> ChunkCoordinates = nmsClassResolver.resolveSilent("ChunkCoordinates");
    static Class<?> BlockPosition = nmsClassResolver.resolveSilent("BlockPosition");
    static Class<?> Vector3f = nmsClassResolver.resolveSilent("Vector3f");
    static Class<?> DataWatcher = nmsClassResolver.resolveSilent("DataWatcher");
    static Class<?> Entity = nmsClassResolver.resolveSilent("Entity");
    static Class<?> TIntObjectMap = classResolver.resolveSilent("gnu.trove.map.TIntObjectMap", "net.minecraft.util.gnu.trove.map.TIntObjectMap");
    static ConstructorResolver DataWacherConstructorResolver = new ConstructorResolver(DataWatcher);
    static FieldResolver DataWatcherFieldResolver = new FieldResolver(DataWatcher);
    static MethodResolver TIntObjectMapMethodResolver = new MethodResolver(TIntObjectMap);
    static MethodResolver DataWatcherMethodResolver = new MethodResolver(DataWatcher);

    public static Object newDataWatcher(@Nullable Object entity) throws ReflectiveOperationException {
        return DataWacherConstructorResolver.resolve(new Class[][]{{Entity}}).newInstance(entity);
    }

    public static Object setValue(Object dataWatcher, int index, Object dataWatcherObject, Object value) throws ReflectiveOperationException {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1)) {
            return V1_8.setValue(dataWatcher, index, value);
        }
        return V1_9.setItem(dataWatcher, index, dataWatcherObject, value);
    }

    public static Object setValue(Object dataWatcher, int index, V1_9.ValueType type, Object value) throws ReflectiveOperationException {
        return org.inventivetalent.reflection.minecraft.DataWatcher.setValue(dataWatcher, index, type.getType(), value);
    }

    public static Object setValue(Object dataWatcher, int index, Object value, FieldResolver dataWatcherObjectFieldResolver, String ... dataWatcherObjectFieldNames) throws ReflectiveOperationException {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1)) {
            return V1_8.setValue(dataWatcher, index, value);
        }
        Object dataWatcherObject = dataWatcherObjectFieldResolver.resolve(dataWatcherObjectFieldNames).get(null);
        return V1_9.setItem(dataWatcher, index, dataWatcherObject, value);
    }

    public static Object getValue(DataWatcher dataWatcher, int index) throws ReflectiveOperationException {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1)) {
            return V1_8.getValue(dataWatcher, index);
        }
        return V1_9.getValue((Object)dataWatcher, index);
    }

    public static int getValueType(Object value) {
        int type = 0;
        if (value instanceof Number) {
            if (value instanceof Byte) {
                type = 0;
            } else if (value instanceof Short) {
                type = 1;
            } else if (value instanceof Integer) {
                type = 2;
            } else if (value instanceof Float) {
                type = 3;
            }
        } else if (value instanceof String) {
            type = 4;
        } else if (value != null && value.getClass().equals(ItemStack)) {
            type = 5;
        } else if (value != null && (value.getClass().equals(ChunkCoordinates) || value.getClass().equals(BlockPosition))) {
            type = 6;
        } else if (value != null && value.getClass().equals(Vector3f)) {
            type = 7;
        }
        return type;
    }

    private DataWatcher() {
    }

    public static class V1_8 {
        static Class<?> WatchableObject = nmsClassResolver.resolveSilent("WatchableObject", "DataWatcher$WatchableObject");
        static ConstructorResolver WatchableObjectConstructorResolver;
        static FieldResolver WatchableObjectFieldResolver;

        public static Object newWatchableObject(int index, Object value) throws ReflectiveOperationException {
            return V1_8.newWatchableObject(org.inventivetalent.reflection.minecraft.DataWatcher.getValueType(value), index, value);
        }

        public static Object newWatchableObject(int type, int index, Object value) throws ReflectiveOperationException {
            if (WatchableObjectConstructorResolver == null) {
                WatchableObjectConstructorResolver = new ConstructorResolver(WatchableObject);
            }
            return WatchableObjectConstructorResolver.resolve(new Class[][]{{Integer.TYPE, Integer.TYPE, Object.class}}).newInstance(type, index, value);
        }

        public static Object setValue(Object dataWatcher, int index, Object value) throws ReflectiveOperationException {
            int type = org.inventivetalent.reflection.minecraft.DataWatcher.getValueType(value);
            Object map = DataWatcherFieldResolver.resolve("dataValues").get(dataWatcher);
            TIntObjectMapMethodResolver.resolve(new ResolverQuery("put", Integer.TYPE, Object.class)).invoke(map, index, V1_8.newWatchableObject(type, index, value));
            return dataWatcher;
        }

        public static Object getValue(Object dataWatcher, int index) throws ReflectiveOperationException {
            Object map = DataWatcherFieldResolver.resolve("dataValues").get(dataWatcher);
            return TIntObjectMapMethodResolver.resolve(new ResolverQuery("get", Integer.TYPE)).invoke(map, index);
        }

        public static int getWatchableObjectIndex(Object object) throws ReflectiveOperationException {
            if (WatchableObjectFieldResolver == null) {
                WatchableObjectFieldResolver = new FieldResolver(WatchableObject);
            }
            return WatchableObjectFieldResolver.resolve("b").getInt(object);
        }

        public static int getWatchableObjectType(Object object) throws ReflectiveOperationException {
            if (WatchableObjectFieldResolver == null) {
                WatchableObjectFieldResolver = new FieldResolver(WatchableObject);
            }
            return WatchableObjectFieldResolver.resolve("a").getInt(object);
        }

        public static Object getWatchableObjectValue(Object object) throws ReflectiveOperationException {
            if (WatchableObjectFieldResolver == null) {
                WatchableObjectFieldResolver = new FieldResolver(WatchableObject);
            }
            return WatchableObjectFieldResolver.resolve("c").get(object);
        }
    }

    public static class V1_9 {
        static Class<?> DataWatcherItem = nmsClassResolver.resolveSilent("DataWatcher$Item");
        static Class<?> DataWatcherObject = nmsClassResolver.resolveSilent("DataWatcherObject");
        static ConstructorResolver DataWatcherItemConstructorResolver;
        static FieldResolver DataWatcherItemFieldResolver;
        static FieldResolver DataWatcherObjectFieldResolver;

        public static Object newDataWatcherItem(Object dataWatcherObject, Object value) throws ReflectiveOperationException {
            if (DataWatcherItemConstructorResolver == null) {
                DataWatcherItemConstructorResolver = new ConstructorResolver(DataWatcherItem);
            }
            return DataWatcherItemConstructorResolver.resolveFirstConstructor().newInstance(dataWatcherObject, value);
        }

        public static Object setItem(Object dataWatcher, int index, Object dataWatcherObject, Object value) throws ReflectiveOperationException {
            return V1_9.setItem(dataWatcher, index, V1_9.newDataWatcherItem(dataWatcherObject, value));
        }

        public static Object setItem(Object dataWatcher, int index, Object dataWatcherItem) throws ReflectiveOperationException {
            Map map = (Map)DataWatcherFieldResolver.resolve("c").get(dataWatcher);
            map.put(index, dataWatcherItem);
            return dataWatcher;
        }

        public static Object getItem(Object dataWatcher, Object dataWatcherObject) throws ReflectiveOperationException {
            return DataWatcherMethodResolver.resolve(new ResolverQuery("c", DataWatcherObject)).invoke(dataWatcher, dataWatcherObject);
        }

        public static Object getValue(Object dataWatcher, Object dataWatcherObject) throws ReflectiveOperationException {
            return DataWatcherMethodResolver.resolve("get").invoke(dataWatcher, dataWatcherObject);
        }

        public static Object getValue(Object dataWatcher, ValueType type) throws ReflectiveOperationException {
            return V1_9.getValue(dataWatcher, type.getType());
        }

        public static Object getItemObject(Object item) throws ReflectiveOperationException {
            if (DataWatcherItemFieldResolver == null) {
                DataWatcherItemFieldResolver = new FieldResolver(DataWatcherItem);
            }
            return DataWatcherItemFieldResolver.resolve("a").get(item);
        }

        public static int getItemIndex(Object dataWatcher, Object item) throws ReflectiveOperationException {
            int index = -1;
            Map map = (Map)DataWatcherFieldResolver.resolve("c").get(dataWatcher);
            for (Map.Entry entry : map.entrySet()) {
                if (!entry.getValue().equals(item)) continue;
                index = (Integer)entry.getKey();
                break;
            }
            return index;
        }

        public static Type getItemType(Object item) throws ReflectiveOperationException {
            Type[] actualTypes;
            Type type;
            if (DataWatcherObjectFieldResolver == null) {
                DataWatcherObjectFieldResolver = new FieldResolver(DataWatcherObject);
            }
            Object object = V1_9.getItemObject(item);
            Object serializer = DataWatcherObjectFieldResolver.resolve("b").get(object);
            Type[] genericInterfaces = serializer.getClass().getGenericInterfaces();
            if (genericInterfaces.length > 0 && (type = genericInterfaces[0]) instanceof ParameterizedType && (actualTypes = ((ParameterizedType)type).getActualTypeArguments()).length > 0) {
                return actualTypes[0];
            }
            return null;
        }

        public static Object getItemValue(Object item) throws ReflectiveOperationException {
            if (DataWatcherItemFieldResolver == null) {
                DataWatcherItemFieldResolver = new FieldResolver(DataWatcherItem);
            }
            return DataWatcherItemFieldResolver.resolve("b").get(item);
        }

        public static void setItemValue(Object item, Object value) throws ReflectiveOperationException {
            DataWatcherItemFieldResolver.resolve("b").set(item, value);
        }

        public static enum ValueType {
            ENTITY_FLAG("Entity", "ax"),
            ENTITY_NAME("Entity", "az"),
            ENTITY_NAME_VISIBLE("Entity", "aA"),
            ENTITY_AIR_TICKS("Entity", "ay"),
            ENTITY_SILENT("Entity", "aB"),
            ENTITY_as("Entity", "as"),
            ENTITY_LIVING_HEALTH("EntityLiving", "HEALTH"),
            ENTITY_LIVING_f("EntityLiving", "f"),
            ENTITY_LIVING_g("EntityLiving", "g"),
            ENTITY_LIVING_h("EntityLiving", "h"),
            ENTITY_INSENTIENT_FLAG("EntityInsentient", "a"),
            ENTITY_SLIME_SIZE("EntitySlime", "bt"),
            ENTITY_WITHER_a("EntityWither", "a"),
            ENTITY_WIHER_b("EntityWither", "b"),
            ENTITY_WITHER_c("EntityWither", "c"),
            ENTITY_WITHER_bv("EntityWither", "bv"),
            ENTITY_WITHER_bw("EntityWither", "bw"),
            ENTITY_HUMAN_ABSORPTION_HEARTS("EntityHuman", "a"),
            ENTITY_HUMAN_SCORE("EntityHuman", "b"),
            ENTITY_HUMAN_SKIN_LAYERS("EntityHuman", "bp"),
            ENTITY_HUMAN_MAIN_HAND("EntityHuman", "bq");

            private Object type;

            private ValueType(String className, String ... fieldNames) {
                try {
                    this.type = new FieldResolver(nmsClassResolver.resolve(className)).resolve(fieldNames).get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public boolean hasType() {
                return this.getType() != null;
            }

            public Object getType() {
                return this.type;
            }
        }
    }
}

