/*
 * Decompiled with CFR 0.152.
 */
package de.inventivegames.hologram.reflection;

import de.inventivegames.hologram.HologramAPI;
import de.inventivegames.hologram.reflection.AccessUtil;
import de.inventivegames.hologram.reflection.NMSClass;
import de.inventivegames.hologram.reflection.NMUClass;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

public abstract class ClassBuilder {
    public static Object buildEntityWitherSkull(Object world, Location loc) throws Exception {
        Object witherSkull = NMSClass.EntityWitherSkull.getConstructor(NMSClass.World).newInstance(world);
        ClassBuilder.updateEntityLocation(witherSkull, loc);
        return witherSkull;
    }

    public static Object buildEntityHorse_1_7(Object world, Location loc, String name) throws Exception {
        Object horse_1_7 = NMSClass.EntityHorse.getConstructor(NMSClass.World).newInstance(world);
        ClassBuilder.updateEntityLocation(horse_1_7, loc);
        if (HologramAPI.is1_8()) {
            if (name != null) {
                NMSClass.Entity.getDeclaredMethod("setCustomName", String.class).invoke(horse_1_7, name);
            }
            NMSClass.Entity.getDeclaredMethod("setCustomNameVisible", Boolean.TYPE).invoke(horse_1_7, name != null && !name.isEmpty());
        } else {
            if (name != null) {
                NMSClass.EntityInsentient.getDeclaredMethod("setCustomName", String.class).invoke(horse_1_7, name);
            }
            NMSClass.EntityInsentient.getDeclaredMethod("setCustomNameVisible", Boolean.TYPE).invoke(horse_1_7, name != null && !name.isEmpty());
        }
        Object horseDataWatcher = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(horse_1_7);
        NMSClass.EntityAgeable.getDeclaredMethod("setAge", Integer.TYPE).invoke(horse_1_7, -1700000);
        NMSClass.DataWatcher.getDeclaredMethod("watch", Integer.TYPE, Object.class).invoke(horseDataWatcher, 12, -1700000);
        return horse_1_7;
    }

    public static Object buildEntityHorse_1_8(Object world, Location loc, String name) throws Exception {
        Object horse_1_8 = NMSClass.EntityHorse.getConstructor(NMSClass.World).newInstance(world);
        ClassBuilder.updateEntityLocation(horse_1_8, loc);
        if (HologramAPI.is1_8()) {
            if (name != null) {
                NMSClass.Entity.getDeclaredMethod("setCustomName", String.class).invoke(horse_1_8, name);
            }
            NMSClass.Entity.getDeclaredMethod("setCustomNameVisible", Boolean.TYPE).invoke(horse_1_8, true);
        } else {
            NMSClass.EntityInsentient.getDeclaredMethod("setCustomName", String.class).invoke(horse_1_8, name);
            NMSClass.EntityInsentient.getDeclaredMethod("setCustomNameVisible", Boolean.TYPE).invoke(horse_1_8, name != null && !name.isEmpty());
        }
        return horse_1_8;
    }

    public static Object buildEntityArmorStand(Object world, Location loc, String name) throws Exception {
        Object armorStand = NMSClass.EntityArmorStand.getConstructor(NMSClass.World).newInstance(world);
        ClassBuilder.updateEntityLocation(armorStand, loc);
        if (name != null) {
            NMSClass.Entity.getDeclaredMethod("setCustomName", String.class).invoke(armorStand, name);
        }
        NMSClass.Entity.getDeclaredMethod("setCustomNameVisible", Boolean.TYPE).invoke(armorStand, name != null && !name.isEmpty());
        return armorStand;
    }

    public static Object setupArmorStand(Object armorStand) throws Exception {
        NMSClass.EntityArmorStand.getDeclaredMethod("setInvisible", Boolean.TYPE).invoke(armorStand, true);
        NMSClass.EntityArmorStand.getDeclaredMethod("setSmall", Boolean.TYPE).invoke(armorStand, true);
        NMSClass.EntityArmorStand.getDeclaredMethod("setArms", Boolean.TYPE).invoke(armorStand, false);
        NMSClass.EntityArmorStand.getDeclaredMethod("setGravity", Boolean.TYPE).invoke(armorStand, false);
        NMSClass.EntityArmorStand.getDeclaredMethod("setBasePlate", Boolean.TYPE).invoke(armorStand, false);
        return armorStand;
    }

    public static Object buildEntitySlime(Object world, Location loc, int size) throws Exception {
        Object slime = NMSClass.EntitySlime.getConstructor(NMSClass.World).newInstance(world);
        ClassBuilder.updateEntityLocation(slime, loc);
        Object dataWatcher = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(slime);
        ClassBuilder.setDataWatcherValue(dataWatcher, 0, (byte)32);
        ClassBuilder.setDataWatcherValue(dataWatcher, 16, (byte)(size < 1 ? 1 : (size > 100 ? 100 : size)));
        return slime;
    }

    public static Object buildWitherSkullSpawnPacket(Object skull) throws Exception {
        Object spawnPacketSkull = NMSClass.PacketPlayOutSpawnEntity.getConstructor(NMSClass.Entity, Integer.TYPE).newInstance(skull, EntityType.WITHER_SKULL.getTypeId());
        AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntity.getDeclaredField("j")).set(spawnPacketSkull, 66);
        return spawnPacketSkull;
    }

    public static Object buildSkullMetaPacket(int id, Object dataWatcher) throws Exception {
        ClassBuilder.setDataWatcherValue(dataWatcher, 0, (byte)32);
        Object packet = NMSClass.PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, NMSClass.DataWatcher, Boolean.TYPE).newInstance(id, dataWatcher, true);
        return packet;
    }

    public static Object buildHorseSpawnPacket_1_7(Object horse, String name) throws Exception {
        if (horse == null) {
            throw new IllegalArgumentException("horse cannot be null");
        }
        Object spawnPacketHorse_1_7 = NMSClass.PacketPlayOutSpawnEntityLiving.getConstructor(NMSClass.EntityLiving).newInstance(horse);
        Object dataWatcher_1_7 = AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("l")).get(spawnPacketHorse_1_7);
        Object map = AccessUtil.setAccessible(NMSClass.DataWatcher.getDeclaredField("dataValues")).get(dataWatcher_1_7);
        if (name != null) {
            ClassBuilder.setDataWatcherValue(dataWatcher_1_7, 10, name);
        }
        ClassBuilder.setDataWatcherValue(dataWatcher_1_7, 11, (byte)(name != null && !name.isEmpty() ? 1 : 0));
        NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("put", Integer.TYPE, Object.class).invoke(map, 12, NMSClass.WatchableObject.getConstructor(Integer.TYPE, Integer.TYPE, Object.class).newInstance(2, 12, -1700000));
        return spawnPacketHorse_1_7;
    }

    public static Object buildHorseSpawnPacket_1_8(Object horse, String name) throws Exception {
        if (horse == null) {
            throw new IllegalArgumentException("horse cannot be null");
        }
        Object spawnPacketHorse_1_8 = NMSClass.PacketPlayOutSpawnEntityLiving.getConstructor(NMSClass.EntityLiving).newInstance(horse);
        AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("b")).setInt(spawnPacketHorse_1_8, 30);
        Object dataWatcher_1_8 = AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("l")).get(spawnPacketHorse_1_8);
        Object map_1_8 = AccessUtil.setAccessible(NMSClass.DataWatcher.getDeclaredField("dataValues")).get(dataWatcher_1_8);
        NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("put", Integer.TYPE, Object.class).invoke(map_1_8, 10, NMSClass.WatchableObject.getConstructor(Integer.TYPE, Integer.TYPE, Object.class).newInstance(0, 10, (byte)1));
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            Object current = NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("get", Integer.TYPE).invoke(map_1_8, i);
            if (current == null) continue;
            int index = AccessUtil.setAccessible(NMSClass.WatchableObject.getDeclaredField("b")).getInt(current);
            if (index == 2) {
                AccessUtil.setAccessible(NMSClass.WatchableObject.getDeclaredField("c")).set(current, name);
                continue;
            }
            if (index == 3) continue;
            toRemove.add(index);
        }
        for (Integer i : toRemove) {
            NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("remove", Integer.TYPE).invoke(map_1_8, i);
        }
        NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("put", Integer.TYPE, Object.class).invoke(map_1_8, 0, NMSClass.WatchableObject.getConstructor(Integer.TYPE, Integer.TYPE, Object.class).newInstance(0, 0, (byte)32));
        return spawnPacketHorse_1_8;
    }

    public static Object buildSlimeSpawnPacket(Object slime) throws Exception {
        Object packet = NMSClass.PacketPlayOutSpawnEntityLiving.getConstructor(NMSClass.EntityLiving).newInstance(slime);
        return packet;
    }

    public static Object buildNameMetadataPacket(int id, Object dataWatcher, int nameIndex, int visibilityIndex, String name) throws Exception {
        dataWatcher = ClassBuilder.setDataWatcherValue(dataWatcher, nameIndex, name != null ? name : "");
        dataWatcher = ClassBuilder.setDataWatcherValue(dataWatcher, visibilityIndex, (byte)(name != null && !name.isEmpty() ? 1 : 0));
        Object metaPacket = NMSClass.PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, NMSClass.DataWatcher, Boolean.TYPE).newInstance(id, dataWatcher, true);
        return metaPacket;
    }

    public static Object updateEntityLocation(Object entity, Location loc) throws Exception {
        NMSClass.Entity.getDeclaredField("locX").set(entity, loc.getX());
        NMSClass.Entity.getDeclaredField("locY").set(entity, loc.getY());
        NMSClass.Entity.getDeclaredField("locZ").set(entity, loc.getZ());
        return entity;
    }

    public static Object buildDataWatcher(@Nullable Object entity) throws Exception {
        Object dataWatcher = NMSClass.DataWatcher.getConstructor(NMSClass.Entity).newInstance(entity);
        return dataWatcher;
    }

    public static Object buildWatchableObject(int index, Object value) throws Exception {
        return ClassBuilder.buildWatchableObject(ClassBuilder.getDataWatcherValueType(value), index, value);
    }

    public static Object buildWatchableObject(int type, int index, Object value) throws Exception {
        return NMSClass.WatchableObject.getConstructor(Integer.TYPE, Integer.TYPE, Object.class).newInstance(type, index, value);
    }

    public static Object setDataWatcherValue(Object dataWatcher, int index, Object value) throws Exception {
        int type = ClassBuilder.getDataWatcherValueType(value);
        Object map = AccessUtil.setAccessible(NMSClass.DataWatcher.getDeclaredField("dataValues")).get(dataWatcher);
        NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("put", Integer.TYPE, Object.class).invoke(map, index, ClassBuilder.buildWatchableObject(type, index, value));
        return dataWatcher;
    }

    public static Object getDataWatcherValue(Object dataWatcher, int index) throws Exception {
        Object map = AccessUtil.setAccessible(NMSClass.DataWatcher.getDeclaredField("dataValues")).get(dataWatcher);
        Object value = NMUClass.gnu_trove_map_hash_TIntObjectHashMap.getDeclaredMethod("get", Integer.TYPE).invoke(map, index);
        return value;
    }

    public static int getWatchableObjectIndex(Object object) throws Exception {
        int index = AccessUtil.setAccessible(NMSClass.WatchableObject.getDeclaredField("b")).getInt(object);
        return index;
    }

    public static int getWatchableObjectType(Object object) throws Exception {
        int type = AccessUtil.setAccessible(NMSClass.WatchableObject.getDeclaredField("a")).getInt(object);
        return type;
    }

    public static Object getWatchableObjectValue(Object object) throws Exception {
        Object value = AccessUtil.setAccessible(NMSClass.WatchableObject.getDeclaredField("c")).get(object);
        return value;
    }

    public static int getDataWatcherValueType(Object value) {
        int type = 0;
        if (value instanceof Number) {
            if (value instanceof Byte) {
                type = 0;
            } else if (value instanceof Short) {
                type = 1;
            } else if (value instanceof Integer) {
                type = 2;
            } else if (value instanceof Float) {
                type = 3;
            }
        } else if (value instanceof String) {
            type = 4;
        } else if (value != null && value.getClass().equals(NMSClass.ItemStack)) {
            type = 5;
        } else if (value != null && (value.getClass().equals(NMSClass.ChunkCoordinates) || value.getClass().equals(NMSClass.BlockPosition))) {
            type = 6;
        } else if (value != null && value.getClass().equals(NMSClass.Vector3f)) {
            type = 7;
        }
        return type;
    }

    public static Object buildArmorStandSpawnPacket(Object armorStand) throws Exception {
        Object spawnPacket = NMSClass.PacketPlayOutSpawnEntityLiving.getConstructor(NMSClass.EntityLiving).newInstance(armorStand);
        AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("b")).setInt(spawnPacket, 30);
        return spawnPacket;
    }

    public static Object buildTeleportPacket(int id, Location loc, boolean onGround, boolean heightCorrection) throws Exception {
        Object packet = NMSClass.PacketPlayOutEntityTeleport.newInstance();
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("a")).set(packet, id);
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("b")).set(packet, (int)(loc.getX() * 32.0));
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("c")).set(packet, (int)(loc.getY() * 32.0));
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("d")).set(packet, (int)(loc.getZ() * 32.0));
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("e")).set(packet, (byte)(loc.getYaw() * 256.0f / 360.0f));
        AccessUtil.setAccessible(NMSClass.PacketPlayOutEntityTeleport.getDeclaredField("f")).set(packet, (byte)(loc.getPitch() * 256.0f / 360.0f));
        return packet;
    }
}

