/*
 * Decompiled with CFR 0.152.
 */
package de.inventivegames.hologram;

import de.inventivegames.hologram.Hologram;
import de.inventivegames.hologram.HologramAPI;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class HologramListeners
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        for (Hologram h : HologramAPI.getHolograms()) {
            if (!h.isSpawned() || !h.getLocation().getWorld().getName().equals(e.getTo().getWorld().getName())) continue;
            try {
                HologramAPI.spawn(h, Arrays.asList(p));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        Player p = e.getPlayer();
        for (Hologram h : HologramAPI.getHolograms()) {
            if (!h.isSpawned() || !h.getLocation().getWorld().getName().equals(p.getWorld().getName())) continue;
            try {
                HologramAPI.spawn(h, Arrays.asList(p));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(ChunkLoadEvent e) {
        for (Hologram h : HologramAPI.getHolograms()) {
            if (!h.isSpawned() || !h.getLocation().getChunk().equals(e.getChunk())) continue;
            try {
                HologramAPI.spawn(h, h.getLocation().getWorld().getPlayers());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

