/*
 * Decompiled with CFR 0.152.
 */
package de.inventivegames.hologram;

import de.inventivegames.hologram.CraftHologram;
import de.inventivegames.hologram.DefaultHologram;
import de.inventivegames.hologram.Hologram;
import de.inventivegames.hologram.reflection.AccessUtil;
import de.inventivegames.hologram.reflection.NMUClass;
import de.inventivegames.hologram.reflection.Reflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class HologramAPI {
    protected static boolean is1_8 = false;
    protected static boolean packetsEnabled = false;
    protected static final List<Hologram> holograms = new ArrayList<Hologram>();

    public static Hologram createHologram(Location loc, String text) {
        DefaultHologram hologram = new DefaultHologram(loc, text);
        holograms.add(hologram);
        return hologram;
    }

    public static boolean removeHologram(Location loc, String text) {
        Hologram toRemove = null;
        for (Hologram h : holograms) {
            if (!h.getLocation().equals((Object)loc) || !h.getText().equals(text)) continue;
            toRemove = h;
            break;
        }
        if (toRemove != null) {
            return HologramAPI.removeHologram(toRemove);
        }
        return false;
    }

    public static boolean removeHologram(@Nonnull Hologram hologram) {
        if (hologram.isSpawned()) {
            hologram.despawn();
        }
        return holograms.remove(hologram);
    }

    public static Collection<Hologram> getHolograms() {
        return new ArrayList<Hologram>(holograms);
    }

    protected static boolean spawn(@Nonnull Hologram hologram, Collection<? extends Player> receivers) throws Exception {
        if (hologram == null) {
            throw new IllegalArgumentException("hologram cannot be null");
        }
        if (receivers.isEmpty()) {
            return false;
        }
        ((CraftHologram)hologram).sendSpawnPackets(receivers, true, true);
        ((CraftHologram)hologram).sendTeleportPackets(receivers, true, true);
        ((CraftHologram)hologram).sendNamePackets(receivers);
        return true;
    }

    protected static boolean despawn(@Nonnull Hologram hologram, Collection<? extends Player> receivers) throws Exception {
        if (hologram == null) {
            throw new IllegalArgumentException("hologram cannot be null");
        }
        if (receivers.isEmpty()) {
            return false;
        }
        ((CraftHologram)hologram).sendDestroyPackets(receivers);
        return true;
    }

    protected static void sendPacket(Player p, Object packet) {
        if (p == null || packet == null) {
            throw new IllegalArgumentException("player and packet cannot be null");
        }
        try {
            Object handle = Reflection.getHandle(p);
            Object connection = Reflection.getField(handle.getClass(), "playerConnection").get(handle);
            Reflection.getMethod(connection.getClass(), "sendPacket", Reflection.getNMSClass("Packet")).invoke(connection, packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static int getVersion(Player p) {
        try {
            Object handle = Reflection.getHandle(p);
            Object connection = AccessUtil.setAccessible(handle.getClass().getDeclaredField("playerConnection")).get(handle);
            Object network = AccessUtil.setAccessible(connection.getClass().getDeclaredField("networkManager")).get(connection);
            String name = null;
            if (is1_8) {
                if (Reflection.getVersion().contains("1_8_R1")) {
                    name = "i";
                }
                if (Reflection.getVersion().contains("1_8_R2")) {
                    name = "k";
                }
            } else {
                name = "m";
            }
            if (name == null) {
                System.err.println("Invalid server version! Unable to find proper channel-field in getVersion.");
                return 0;
            }
            Object channel = AccessUtil.setAccessible(network.getClass().getDeclaredField(name)).get(network);
            Object version = 0;
            try {
                version = AccessUtil.setAccessible(network.getClass().getDeclaredMethod("getVersion", NMUClass.io_netty_channel_Channel)).invoke(network, channel);
            }
            catch (Exception e) {
                return 182;
            }
            return (Integer)version;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean is1_8() {
        return is1_8;
    }

    public static boolean packetsEnabled() {
        return packetsEnabled;
    }

    static {
        is1_8 = Reflection.getVersion().contains("1_8");
    }
}

