/*
 * Decompiled with CFR 0.152.
 */
package de.inventivegames.hologram;

import de.inventivegames.hologram.Hologram;
import de.inventivegames.hologram.HologramAPI;
import de.inventivegames.hologram.HologramPlugin;
import de.inventivegames.hologram.reflection.AccessUtil;
import de.inventivegames.hologram.reflection.ClassBuilder;
import de.inventivegames.hologram.reflection.NMSClass;
import de.inventivegames.hologram.reflection.Reflection;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

abstract class CraftHologram
implements Hologram {
    protected int[] hologramIDs;
    protected int[] touchIDs;
    protected boolean packetsBuilt;
    protected Object spawnPacketArmorStand;
    protected Object spawnPacketWitherSkull;
    protected Object spawnPacketHorse_1_7;
    protected Object spawnPacketHorse_1_8;
    protected Object attachPacket;
    protected Object teleportPacketArmorStand;
    protected Object teleportPacketSkull;
    protected Object teleportPacketHorse_1_7;
    protected Object teleportPacketHorse_1_8;
    protected Object destroyPacket;
    protected Object spawnPacketTouchSlime;
    protected Object spawnPacketTouchVehicle;
    protected Object attachPacketTouch;
    protected Object destroyPacketTouch;
    protected Object teleportPacketTouchSlime;
    protected Object teleportPacketTouchVehicle;
    protected Object dataWatcherArmorStand;
    protected Object dataWatcherWitherSkull;
    protected Object dataWatcherHorse_1_7;
    protected Object dataWatcherHorse_1_8;
    protected Object dataWatcherTouchSlime;
    protected Object dataWatcherTouchVehicle;

    CraftHologram() {
    }

    protected boolean matchesTouchID(int id) {
        if (!this.isTouchable() || this.touchIDs == null) {
            return false;
        }
        for (int i : this.touchIDs) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesHologramID(int id) {
        if (!HologramAPI.packetsEnabled() || this.hologramIDs == null) {
            return false;
        }
        for (int i : this.hologramIDs) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    protected void buildPackets(boolean rebuild) throws Exception {
        Field entityCountField;
        if (!rebuild && this.packetsBuilt) {
            throw new IllegalStateException("packets already built");
        }
        if (rebuild && !this.packetsBuilt) {
            throw new IllegalStateException("cannot rebuild packets before building once");
        }
        Object world = Reflection.getHandle(this.getLocation().getWorld());
        if (HologramAPI.is1_8) {
            Object armorStand = ClassBuilder.buildEntityArmorStand(world, this.getLocation().add(0.0, -1.25, 0.0), this.getText());
            ClassBuilder.setupArmorStand(armorStand);
            if (rebuild) {
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(armorStand, this.hologramIDs[0]);
            } else {
                this.hologramIDs = new int[]{AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(armorStand)};
            }
            this.spawnPacketArmorStand = ClassBuilder.buildArmorStandSpawnPacket(armorStand);
            this.dataWatcherArmorStand = AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("l")).get(this.spawnPacketArmorStand);
            this.teleportPacketArmorStand = ClassBuilder.buildTeleportPacket(this.hologramIDs[0], this.getLocation().add(0.0, -1.25, 0.0), true, false);
        } else {
            Object horse_1_7 = ClassBuilder.buildEntityHorse_1_7(world, this.getLocation().add(0.0, 54.56, 0.0), this.getText());
            Object horse_1_8 = ClassBuilder.buildEntityHorse_1_8(world, this.getLocation().add(0.0, -2.25, 0.0), this.getText());
            Object witherSkull_1_7 = ClassBuilder.buildEntityWitherSkull(world, this.getLocation().add(0.0, 54.56, 0.0));
            this.dataWatcherWitherSkull = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(witherSkull_1_7);
            if (rebuild) {
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(witherSkull_1_7, this.hologramIDs[0]);
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(horse_1_7, this.hologramIDs[1]);
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(horse_1_8, this.hologramIDs[2]);
                entityCountField = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("entityCount"));
                entityCountField.set(null, (Integer)entityCountField.get(null) - 3);
            } else {
                this.hologramIDs = new int[]{AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(witherSkull_1_7), AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(horse_1_7), AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(horse_1_8)};
            }
            this.spawnPacketHorse_1_7 = ClassBuilder.buildHorseSpawnPacket_1_7(horse_1_7, this.getText());
            this.dataWatcherHorse_1_7 = AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("l")).get(this.spawnPacketHorse_1_7);
            this.spawnPacketHorse_1_8 = ClassBuilder.buildHorseSpawnPacket_1_8(horse_1_8, this.getText());
            this.dataWatcherHorse_1_8 = AccessUtil.setAccessible(NMSClass.PacketPlayOutSpawnEntityLiving.getDeclaredField("l")).get(this.spawnPacketHorse_1_8);
            this.spawnPacketWitherSkull = ClassBuilder.buildWitherSkullSpawnPacket(witherSkull_1_7);
            this.attachPacket = NMSClass.PacketPlayOutAttachEntity.getConstructor(Integer.TYPE, NMSClass.Entity, NMSClass.Entity).newInstance(0, horse_1_7, witherSkull_1_7);
            AccessUtil.setAccessible(NMSClass.PacketPlayOutAttachEntity.getDeclaredField("b")).set(this.attachPacket, this.hologramIDs[1]);
            AccessUtil.setAccessible(NMSClass.PacketPlayOutAttachEntity.getDeclaredField("c")).set(this.attachPacket, this.hologramIDs[0]);
            if (!HologramAPI.is1_8) {
                this.teleportPacketSkull = ClassBuilder.buildTeleportPacket(this.hologramIDs[0], this.getLocation().add(0.0, 54.56, 0.0), true, false);
                this.teleportPacketHorse_1_7 = ClassBuilder.buildTeleportPacket(this.hologramIDs[1], this.getLocation().add(0.0, 54.56, 0.0), true, false);
            }
            this.teleportPacketHorse_1_8 = ClassBuilder.buildTeleportPacket(this.hologramIDs[2], this.getLocation().add(0.0, -2.25, 0.0), true, false);
        }
        if (this.isTouchable()) {
            int size = this.getText() == null ? 1 : this.getText().length() / 2 / 3;
            Object touchSlime = ClassBuilder.buildEntitySlime(world, this.getLocation().add(0.0, -0.4, 0.0), size);
            this.dataWatcherTouchSlime = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(touchSlime);
            Object touchVehicle = null;
            if (HologramAPI.is1_8) {
                touchVehicle = ClassBuilder.buildEntityArmorStand(world, this.getLocation().add(0.0, -1.85, 0.0), null);
                this.dataWatcherTouchVehicle = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(touchVehicle);
                ClassBuilder.setupArmorStand(touchVehicle);
            } else {
                touchVehicle = ClassBuilder.buildEntityWitherSkull(world, this.getLocation().add(0.0, -0.4, 0.0));
                this.dataWatcherTouchVehicle = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("datawatcher")).get(touchVehicle);
                ClassBuilder.setDataWatcherValue(this.dataWatcherTouchVehicle, 0, (byte)32);
            }
            if (rebuild) {
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(touchSlime, this.touchIDs[0]);
                AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).set(touchVehicle, this.touchIDs[1]);
                entityCountField = AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("entityCount"));
                entityCountField.set(null, (Integer)entityCountField.get(null) - 2);
            } else {
                this.touchIDs = new int[]{AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(touchSlime), AccessUtil.setAccessible(NMSClass.Entity.getDeclaredField("id")).getInt(touchVehicle)};
            }
            this.spawnPacketTouchSlime = ClassBuilder.buildSlimeSpawnPacket(touchSlime);
            this.spawnPacketTouchVehicle = HologramAPI.is1_8 ? ClassBuilder.buildArmorStandSpawnPacket(touchVehicle) : ClassBuilder.buildWitherSkullSpawnPacket(touchVehicle);
            this.attachPacketTouch = NMSClass.PacketPlayOutAttachEntity.getConstructor(Integer.TYPE, NMSClass.Entity, NMSClass.Entity).newInstance(0, touchSlime, touchVehicle);
            AccessUtil.setAccessible(NMSClass.PacketPlayOutAttachEntity.getDeclaredField("b")).set(this.attachPacketTouch, this.touchIDs[0]);
            AccessUtil.setAccessible(NMSClass.PacketPlayOutAttachEntity.getDeclaredField("c")).set(this.attachPacketTouch, this.touchIDs[1]);
            this.teleportPacketTouchSlime = ClassBuilder.buildTeleportPacket(this.touchIDs[0], this.getLocation().add(0.0, -0.4, 0.0), true, false);
            this.teleportPacketTouchVehicle = HologramAPI.is1_8 ? ClassBuilder.buildTeleportPacket(this.touchIDs[1], this.getLocation().add(0.0, -1.85, 0.0), true, false) : ClassBuilder.buildTeleportPacket(this.touchIDs[1], this.getLocation().add(0.0, -0.4, 0.0), true, false);
            if (!rebuild) {
                this.destroyPacketTouch = NMSClass.PacketPlayOutEntityDestroy.getConstructor(int[].class).newInstance(new Object[]{this.touchIDs});
            }
        }
        if (!rebuild) {
            this.destroyPacket = NMSClass.PacketPlayOutEntityDestroy.getConstructor(int[].class).newInstance(new Object[]{this.hologramIDs});
        }
    }

    protected void sendSpawnPackets(final Collection<? extends Player> receivers, final boolean holo, final boolean touch) {
        if (holo) {
            if (HologramAPI.is1_8) {
                for (Player player : receivers) {
                    HologramAPI.sendPacket(player, this.spawnPacketArmorStand);
                }
            } else {
                for (Player player : receivers) {
                    if (HologramAPI.getVersion(player) > 5) {
                        HologramAPI.sendPacket(player, this.spawnPacketHorse_1_8);
                        continue;
                    }
                    HologramAPI.sendPacket(player, this.spawnPacketHorse_1_7);
                    HologramAPI.sendPacket(player, this.spawnPacketWitherSkull);
                    HologramAPI.sendPacket(player, this.attachPacket);
                }
            }
        }
        if (touch && this.isTouchable()) {
            for (Player player : receivers) {
                HologramAPI.sendPacket(player, this.spawnPacketTouchSlime);
                HologramAPI.sendPacket(player, this.spawnPacketTouchVehicle);
                HologramAPI.sendPacket(player, this.attachPacketTouch);
            }
        }
        if (holo || touch) {
            new BukkitRunnable(){

                public void run() {
                    CraftHologram.this.sendTeleportPackets(receivers, holo, touch);
                }
            }.runTaskLater((Plugin)HologramPlugin.instance, 1L);
        }
    }

    protected void sendTeleportPackets(Collection<? extends Player> receivers, boolean holo, boolean touch) {
        if (!holo && !touch) {
            return;
        }
        for (Player player : receivers) {
            if (holo) {
                if (!HologramAPI.is1_8) {
                    if (HologramAPI.getVersion(player) > 5) {
                        HologramAPI.sendPacket(player, this.teleportPacketHorse_1_8);
                    } else {
                        HologramAPI.sendPacket(player, this.teleportPacketHorse_1_7);
                        HologramAPI.sendPacket(player, this.teleportPacketSkull);
                    }
                } else {
                    HologramAPI.sendPacket(player, this.teleportPacketArmorStand);
                }
            }
            if (!touch || !this.isTouchable()) continue;
            HologramAPI.sendPacket(player, this.teleportPacketTouchSlime);
            HologramAPI.sendPacket(player, this.teleportPacketTouchVehicle);
        }
    }

    protected void sendNamePackets(Collection<? extends Player> receivers) {
        for (Player player : receivers) {
            try {
                int id;
                int n = HologramAPI.is1_8 ? this.hologramIDs[0] : (id = HologramAPI.getVersion(player) > 5 ? this.hologramIDs[2] : this.hologramIDs[1]);
                Object dataWatcher = HologramAPI.is1_8 ? this.dataWatcherArmorStand : (HologramAPI.getVersion(player) > 5 ? this.dataWatcherHorse_1_8 : this.dataWatcherHorse_1_7);
                Object packet = ClassBuilder.buildNameMetadataPacket(id, dataWatcher, 2, 3, this.getText());
                HologramAPI.sendPacket(player, packet);
                if (HologramAPI.getVersion(player) > 5) continue;
                HologramAPI.sendPacket(player, ClassBuilder.buildNameMetadataPacket(this.hologramIDs[1], this.dataWatcherHorse_1_7, 10, 11, this.getText()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void sendDestroyPackets(Collection<? extends Player> receivers) {
        for (Player player : receivers) {
            HologramAPI.sendPacket(player, this.destroyPacket);
            if (!this.isTouchable()) continue;
            HologramAPI.sendPacket(player, this.destroyPacketTouch);
        }
    }

    @Override
    public abstract void setLocation(Location var1);

    @Override
    public abstract Location getLocation();

    @Override
    public abstract void setText(String var1);

    @Override
    public abstract String getText();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachPacket == null ? 0 : this.attachPacket.hashCode());
        result = 31 * result + (this.attachPacketTouch == null ? 0 : this.attachPacketTouch.hashCode());
        result = 31 * result + (this.dataWatcherArmorStand == null ? 0 : this.dataWatcherArmorStand.hashCode());
        result = 31 * result + (this.dataWatcherHorse_1_7 == null ? 0 : this.dataWatcherHorse_1_7.hashCode());
        result = 31 * result + (this.dataWatcherHorse_1_8 == null ? 0 : this.dataWatcherHorse_1_8.hashCode());
        result = 31 * result + (this.dataWatcherTouchSlime == null ? 0 : this.dataWatcherTouchSlime.hashCode());
        result = 31 * result + (this.dataWatcherTouchVehicle == null ? 0 : this.dataWatcherTouchVehicle.hashCode());
        result = 31 * result + (this.dataWatcherWitherSkull == null ? 0 : this.dataWatcherWitherSkull.hashCode());
        result = 31 * result + (this.destroyPacket == null ? 0 : this.destroyPacket.hashCode());
        result = 31 * result + (this.destroyPacketTouch == null ? 0 : this.destroyPacketTouch.hashCode());
        result = 31 * result + Arrays.hashCode(this.hologramIDs);
        result = 31 * result + (this.packetsBuilt ? 1231 : 1237);
        result = 31 * result + (this.spawnPacketArmorStand == null ? 0 : this.spawnPacketArmorStand.hashCode());
        result = 31 * result + (this.spawnPacketHorse_1_7 == null ? 0 : this.spawnPacketHorse_1_7.hashCode());
        result = 31 * result + (this.spawnPacketHorse_1_8 == null ? 0 : this.spawnPacketHorse_1_8.hashCode());
        result = 31 * result + (this.spawnPacketTouchSlime == null ? 0 : this.spawnPacketTouchSlime.hashCode());
        result = 31 * result + (this.spawnPacketTouchVehicle == null ? 0 : this.spawnPacketTouchVehicle.hashCode());
        result = 31 * result + (this.spawnPacketWitherSkull == null ? 0 : this.spawnPacketWitherSkull.hashCode());
        result = 31 * result + (this.teleportPacketArmorStand == null ? 0 : this.teleportPacketArmorStand.hashCode());
        result = 31 * result + (this.teleportPacketHorse_1_7 == null ? 0 : this.teleportPacketHorse_1_7.hashCode());
        result = 31 * result + (this.teleportPacketHorse_1_8 == null ? 0 : this.teleportPacketHorse_1_8.hashCode());
        result = 31 * result + (this.teleportPacketSkull == null ? 0 : this.teleportPacketSkull.hashCode());
        result = 31 * result + (this.teleportPacketTouchSlime == null ? 0 : this.teleportPacketTouchSlime.hashCode());
        result = 31 * result + (this.teleportPacketTouchVehicle == null ? 0 : this.teleportPacketTouchVehicle.hashCode());
        result = 31 * result + Arrays.hashCode(this.touchIDs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftHologram other = (CraftHologram)obj;
        if (this.attachPacket == null ? other.attachPacket != null : !this.attachPacket.equals(other.attachPacket)) {
            return false;
        }
        if (this.attachPacketTouch == null ? other.attachPacketTouch != null : !this.attachPacketTouch.equals(other.attachPacketTouch)) {
            return false;
        }
        if (this.dataWatcherArmorStand == null ? other.dataWatcherArmorStand != null : !this.dataWatcherArmorStand.equals(other.dataWatcherArmorStand)) {
            return false;
        }
        if (this.dataWatcherHorse_1_7 == null ? other.dataWatcherHorse_1_7 != null : !this.dataWatcherHorse_1_7.equals(other.dataWatcherHorse_1_7)) {
            return false;
        }
        if (this.dataWatcherHorse_1_8 == null ? other.dataWatcherHorse_1_8 != null : !this.dataWatcherHorse_1_8.equals(other.dataWatcherHorse_1_8)) {
            return false;
        }
        if (this.dataWatcherTouchSlime == null ? other.dataWatcherTouchSlime != null : !this.dataWatcherTouchSlime.equals(other.dataWatcherTouchSlime)) {
            return false;
        }
        if (this.dataWatcherTouchVehicle == null ? other.dataWatcherTouchVehicle != null : !this.dataWatcherTouchVehicle.equals(other.dataWatcherTouchVehicle)) {
            return false;
        }
        if (this.dataWatcherWitherSkull == null ? other.dataWatcherWitherSkull != null : !this.dataWatcherWitherSkull.equals(other.dataWatcherWitherSkull)) {
            return false;
        }
        if (this.destroyPacket == null ? other.destroyPacket != null : !this.destroyPacket.equals(other.destroyPacket)) {
            return false;
        }
        if (this.destroyPacketTouch == null ? other.destroyPacketTouch != null : !this.destroyPacketTouch.equals(other.destroyPacketTouch)) {
            return false;
        }
        if (!Arrays.equals(this.hologramIDs, other.hologramIDs)) {
            return false;
        }
        if (this.packetsBuilt != other.packetsBuilt) {
            return false;
        }
        if (this.spawnPacketArmorStand == null ? other.spawnPacketArmorStand != null : !this.spawnPacketArmorStand.equals(other.spawnPacketArmorStand)) {
            return false;
        }
        if (this.spawnPacketHorse_1_7 == null ? other.spawnPacketHorse_1_7 != null : !this.spawnPacketHorse_1_7.equals(other.spawnPacketHorse_1_7)) {
            return false;
        }
        if (this.spawnPacketHorse_1_8 == null ? other.spawnPacketHorse_1_8 != null : !this.spawnPacketHorse_1_8.equals(other.spawnPacketHorse_1_8)) {
            return false;
        }
        if (this.spawnPacketTouchSlime == null ? other.spawnPacketTouchSlime != null : !this.spawnPacketTouchSlime.equals(other.spawnPacketTouchSlime)) {
            return false;
        }
        if (this.spawnPacketTouchVehicle == null ? other.spawnPacketTouchVehicle != null : !this.spawnPacketTouchVehicle.equals(other.spawnPacketTouchVehicle)) {
            return false;
        }
        if (this.spawnPacketWitherSkull == null ? other.spawnPacketWitherSkull != null : !this.spawnPacketWitherSkull.equals(other.spawnPacketWitherSkull)) {
            return false;
        }
        if (this.teleportPacketArmorStand == null ? other.teleportPacketArmorStand != null : !this.teleportPacketArmorStand.equals(other.teleportPacketArmorStand)) {
            return false;
        }
        if (this.teleportPacketHorse_1_7 == null ? other.teleportPacketHorse_1_7 != null : !this.teleportPacketHorse_1_7.equals(other.teleportPacketHorse_1_7)) {
            return false;
        }
        if (this.teleportPacketHorse_1_8 == null ? other.teleportPacketHorse_1_8 != null : !this.teleportPacketHorse_1_8.equals(other.teleportPacketHorse_1_8)) {
            return false;
        }
        if (this.teleportPacketSkull == null ? other.teleportPacketSkull != null : !this.teleportPacketSkull.equals(other.teleportPacketSkull)) {
            return false;
        }
        if (this.teleportPacketTouchSlime == null ? other.teleportPacketTouchSlime != null : !this.teleportPacketTouchSlime.equals(other.teleportPacketTouchSlime)) {
            return false;
        }
        if (this.teleportPacketTouchVehicle == null ? other.teleportPacketTouchVehicle != null : !this.teleportPacketTouchVehicle.equals(other.teleportPacketTouchVehicle)) {
            return false;
        }
        return Arrays.equals(this.touchIDs, other.touchIDs);
    }

    public String toString() {
        return "{\"hologramIDs\":\"" + Arrays.toString(this.hologramIDs) + "\",\"touchIDs\":\"" + Arrays.toString(this.touchIDs) + "\",\"packetsBuilt\":\"" + this.packetsBuilt + "\",\"spawnPacketArmorStand\":\"" + this.spawnPacketArmorStand + "\",\"spawnPacketWitherSkull\":\"" + this.spawnPacketWitherSkull + "\",\"spawnPacketHorse_1_7\":\"" + this.spawnPacketHorse_1_7 + "\",\"spawnPacketHorse_1_8\":\"" + this.spawnPacketHorse_1_8 + "\",\"attachPacket\":\"" + this.attachPacket + "\",\"teleportPacketArmorStand\":\"" + this.teleportPacketArmorStand + "\",\"teleportPacketSkull\":\"" + this.teleportPacketSkull + "\",\"teleportPacketHorse_1_7\":\"" + this.teleportPacketHorse_1_7 + "\",\"teleportPacketHorse_1_8\":\"" + this.teleportPacketHorse_1_8 + "\",\"destroyPacket\":\"" + this.destroyPacket + "\",\"spawnPacketTouchSlime\":\"" + this.spawnPacketTouchSlime + "\",\"spawnPacketTouchWitherSkull\":\"" + this.spawnPacketTouchVehicle + "\",\"attachPacketTouch\":\"" + this.attachPacketTouch + "\",\"destroyPacketTouch\":\"" + this.destroyPacketTouch + "\",\"teleportPacketTouchSlime\":\"" + this.teleportPacketTouchSlime + "\",\"teleportPacketTouchWitherSkull\":\"" + this.teleportPacketTouchVehicle + "\",\"dataWatcherArmorStand\":\"" + this.dataWatcherArmorStand + "\",\"dataWatcherWitherSkull\":\"" + this.dataWatcherWitherSkull + "\",\"dataWatcherHorse_1_7\":\"" + this.dataWatcherHorse_1_7 + "\",\"dataWatcherHorse_1_8\":\"" + this.dataWatcherHorse_1_8 + "\",\"dataWatcherTouchSlime\":\"" + this.dataWatcherTouchSlime + "\",\"dataWatcherTouchWitherSkull\":\"" + this.dataWatcherTouchVehicle + "\"}";
    }
}

