/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.boundingbox;

import com.google.gson.annotations.Expose;
import org.bukkit.util.Vector;
import org.inventivetalent.reflection.resolver.FieldResolver;
import org.inventivetalent.reflection.resolver.minecraft.NMSClassResolver;
import org.inventivetalent.vectors.d3.Vector3DDouble;

public class BoundingBox {
    static NMSClassResolver nmsClassResolver = new NMSClassResolver();
    static Class<?> AxisAlignedBB = nmsClassResolver.resolveSilent("AxisAlignedBB");
    static FieldResolver AxisAlignedBBFieldResolver = new FieldResolver(AxisAlignedBB);
    @Expose
    public final double minX;
    @Expose
    public final double minY;
    @Expose
    public final double minZ;
    @Expose
    public final double maxX;
    @Expose
    public final double maxY;
    @Expose
    public final double maxZ;

    public BoundingBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public BoundingBox(Vector vector1, Vector vector2) {
        this(vector1.getX(), vector1.getY(), vector1.getZ(), vector2.getX(), vector2.getY(), vector2.getZ());
    }

    public BoundingBox(Vector3DDouble vector1, Vector3DDouble vector2) {
        this(vector1.getX(), vector1.getY(), vector1.getZ(), vector2.getX(), vector2.getY(), vector2.getZ());
    }

    public BoundingBox expand(double x, double y, double z) {
        double minX = this.minX - x;
        double minY = this.minY - y;
        double minZ = this.minZ - z;
        double maxX = this.maxX + x;
        double maxY = this.maxY + y;
        double maxZ = this.maxZ + z;
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BoundingBox expand(double d) {
        return this.expand(d, d, d);
    }

    public BoundingBox shrink(double x, double y, double z) {
        return this.expand(-x, -y, -z);
    }

    public BoundingBox shrink(double d) {
        return this.shrink(d, d, d);
    }

    public BoundingBox add(double x, double y, double z) {
        double minX = this.minX;
        double minY = this.minY;
        double minZ = this.minZ;
        double maxX = this.maxX;
        double maxY = this.maxY;
        double maxZ = this.maxZ;
        if (x < 0.0) {
            minX += x;
        } else if (x > 0.0) {
            maxX += x;
        }
        if (y < 0.0) {
            minY += y;
        } else if (y > 0.0) {
            maxY += y;
        }
        if (z < 0.0) {
            minZ += z;
        } else if (z > 0.0) {
            maxZ += z;
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BoundingBox translate(double x, double y, double z) {
        return new BoundingBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public BoundingBox translate(Vector3DDouble vector) {
        return this.translate(vector.getX(), vector.getY(), vector.getZ());
    }

    public boolean contains(double x, double y, double z) {
        return x > this.minX && x < this.maxX && y > this.minY && y < this.maxY && z > this.minZ && z < this.maxZ;
    }

    public boolean contains(Vector3DDouble vector) {
        return this.contains(vector.getX(), vector.getY(), vector.getZ());
    }

    public boolean contains(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.minX < minX && this.maxX > maxX && this.minY < minY && this.maxY > maxY && this.minZ < minZ && this.maxZ > maxZ;
    }

    public boolean contains(BoundingBox other) {
        return this.contains(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    public boolean intersects(BoundingBox boundingBox) {
        return this.intersects(boundingBox.minX, boundingBox.minY, boundingBox.minZ, boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
    }

    public BoundingBox combine(BoundingBox boundingBox) {
        double minX = Math.min(this.minX, boundingBox.minX);
        double minY = Math.min(this.minY, boundingBox.minY);
        double minZ = Math.min(this.minZ, boundingBox.minZ);
        double maxX = Math.max(this.maxX, boundingBox.maxX);
        double maxY = Math.max(this.maxY, boundingBox.maxY);
        double maxZ = Math.max(this.maxZ, boundingBox.maxZ);
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Vector3DDouble size() {
        return new Vector3DDouble(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public Vector3DDouble getMinVector() {
        return new Vector3DDouble(this.minX, this.minY, this.minZ);
    }

    public Vector3DDouble getMaxVector() {
        return new Vector3DDouble(this.maxX, this.maxY, this.maxZ);
    }

    public Vector getMinBukkitVector() {
        return new Vector(this.minX, this.minY, this.minZ);
    }

    public Vector getMaxBukkitVector() {
        return new Vector(this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "BoundingBox{(" + this.minX + "," + this.minY + "," + this.minZ + ")-(" + this.maxX + "," + this.maxY + "," + this.maxZ + ")" + "size=(" + (this.maxX - this.minX) + "," + (this.maxY - this.minY) + "," + (this.maxZ - this.minZ) + ")" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (Double.compare(that.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(that.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(that.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(that.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(that.maxY, this.maxY) != 0) {
            return false;
        }
        return Double.compare(that.maxZ, this.maxZ) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Object toNMS() {
        try {
            return AxisAlignedBB.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BoundingBox fromNMS(Object axisAlignedBB) {
        try {
            double a = (Double)AxisAlignedBBFieldResolver.resolve("a").get(axisAlignedBB);
            double b = (Double)AxisAlignedBBFieldResolver.resolve("b").get(axisAlignedBB);
            double c = (Double)AxisAlignedBBFieldResolver.resolve("c").get(axisAlignedBB);
            double d = (Double)AxisAlignedBBFieldResolver.resolve("d").get(axisAlignedBB);
            double e = (Double)AxisAlignedBBFieldResolver.resolve("e").get(axisAlignedBB);
            double f = (Double)AxisAlignedBBFieldResolver.resolve("f").get(axisAlignedBB);
            return new BoundingBox(a, b, c, d, e, f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }
}

