/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class Iterators {
    public static <I, O> Iterator<O> createCompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> convertor) {
        return new CompoundIterator<I, O>(inputs, convertor);
    }

    private static class CompoundIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> inputs;
        private final Function<I, Iterator<O>> convertor;
        private Iterator<O> currentIterator;

        public CompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> convertor) {
            this.inputs = inputs.iterator();
            this.convertor = convertor;
        }

        @Override
        public boolean hasNext() {
            while (this.inputs.hasNext() && (this.currentIterator == null || !this.currentIterator.hasNext())) {
                this.currentIterator = this.convertor.apply(this.inputs.next());
            }
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public O next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

