/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

class SourceParser {
    private static final Pattern PACKAGE = Pattern.compile("\\bpackage\\s([^;]*);");
    private static final Pattern TYPE = Pattern.compile("\\b(class|interface|enum|@interface)\\s+([^\\s<>]+)");
    private static final Pattern METHOD = Pattern.compile("\\b([^\\s()<>,.]+)\\s*\\(([^()]*)\\)\\s*(throws\\b|$)");
    private static final Pattern ARGUMENTS = Pattern.compile(",?[^,]+\\s([^\\s.,]+)\\s*");
    private static final Pattern IDENTIFIER = Pattern.compile("[^\\s.,]+(\\s*\\.\\s*[^\\s.,]+)*");
    private final EventHandler eventHandler;
    private final StringBuilder statement;
    private State state;

    SourceParser(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.statement = new StringBuilder();
        this.state = State.CODE;
    }

    public void parse(char c) {
        block0 : switch (this.state) {
            case CODE: 
            case SLASH: {
                this.statement.append(c);
                switch (c) {
                    case '{': {
                        this.statement.deleteCharAt(this.statement.length() - 1);
                        this.onBlockStart(this.statement.toString().trim());
                        this.statement.setLength(0);
                        break;
                    }
                    case '}': {
                        this.eventHandler.onBlockEnd();
                        this.statement.setLength(0);
                        break;
                    }
                    case ';': {
                        this.onStatement(this.statement);
                        this.statement.setLength(0);
                        break;
                    }
                    case '\"': {
                        this.state = State.STRING_LITERAL;
                        break;
                    }
                    case '/': {
                        if (this.state == State.CODE) {
                            this.state = State.SLASH;
                            break;
                        }
                        this.state = State.LINE_COMMENT;
                        this.statement.delete(this.statement.length() - 2, this.statement.length());
                        break;
                    }
                    case '*': {
                        if (this.state == State.CODE) {
                            this.state = State.CODE;
                            break;
                        }
                        this.state = State.BLOCK_COMMENT;
                        this.statement.delete(this.statement.length() - 2, this.statement.length());
                    }
                }
                break;
            }
            case STRING_LITERAL: {
                switch (c) {
                    case '\\': {
                        this.state = State.STRING_LITERAL_ESCAPE;
                        break;
                    }
                    case '\"': {
                        this.statement.append(c);
                        this.state = State.CODE;
                    }
                }
                break;
            }
            case STRING_LITERAL_ESCAPE: {
                this.statement.append(c);
                this.state = State.STRING_LITERAL;
                break;
            }
            case CHAR_LITERAL: {
                switch (c) {
                    case '\\': {
                        this.state = State.CHAR_LITERAL_ESCAPE;
                        break;
                    }
                    case '\'': {
                        this.statement.append(c);
                        this.state = State.CODE;
                    }
                }
                break;
            }
            case CHAR_LITERAL_ESCAPE: {
                this.state = State.CHAR_LITERAL;
                break;
            }
            case LINE_COMMENT: {
                if (c != '\n') break;
                this.state = State.CODE;
                break;
            }
            case BLOCK_COMMENT: 
            case BLOCK_COMMENT_STAR: {
                switch (c) {
                    case '*': {
                        this.state = State.BLOCK_COMMENT_STAR;
                        break block0;
                    }
                    case '/': {
                        if (this.state != State.BLOCK_COMMENT_STAR) break block0;
                        this.state = State.CODE;
                        break block0;
                    }
                }
                this.state = State.BLOCK_COMMENT;
            }
        }
    }

    private void onStatement(CharSequence chars) {
        Matcher packageMatcher = PACKAGE.matcher(chars);
        if (packageMatcher.find()) {
            String packageName = packageMatcher.group(1).replaceAll("\\s+", "");
            Preconditions.checkState(!packageName.isEmpty(), "Unexpected ';'");
            this.eventHandler.onPackageStatement(packageName);
        }
    }

    private void onBlockStart(CharSequence raw) {
        String methodName;
        CharSequence chars = SourceParser.withoutTypeParams(SourceParser.withoutAnnotations(raw));
        if (chars == null) {
            this.eventHandler.onOtherBlockStart();
            return;
        }
        Matcher typeMatcher = TYPE.matcher(chars);
        if (typeMatcher.find()) {
            Set<String> supertypes = SourceParser.supertypes(chars.subSequence(typeMatcher.end(), chars.length()));
            this.eventHandler.onTypeBlockStart(typeMatcher.group(1), typeMatcher.group(2), supertypes);
            return;
        }
        Matcher methodMatcher = METHOD.matcher(chars);
        if (methodMatcher.find() && !SourceVersion.isKeyword(methodName = methodMatcher.group(1))) {
            LinkedHashSet<String> args = new LinkedHashSet<String>();
            Matcher argMatcher = ARGUMENTS.matcher(methodMatcher.group(2));
            int index = 0;
            while (argMatcher.find() && argMatcher.start() == index) {
                args.add(argMatcher.group(1));
                index = argMatcher.end();
            }
            if (index == methodMatcher.group(2).length()) {
                this.eventHandler.onMethodBlockStart(methodName, args);
                return;
            }
        }
        this.eventHandler.onOtherBlockStart();
    }

    private static Set<String> supertypes(CharSequence chars) {
        HashSet<String> types = new HashSet<String>();
        Matcher rawTypeMatcher = IDENTIFIER.matcher(chars);
        while (rawTypeMatcher.find()) {
            String[] identifierParts = rawTypeMatcher.group().split("\\.");
            StringBuilder identifier = new StringBuilder();
            String separator = "";
            for (String part : identifierParts) {
                Preconditions.checkState(SourceVersion.isIdentifier(part.trim()), "Invalid identifier %s", rawTypeMatcher.group());
                identifier.append(separator).append(part.trim());
                separator = ".";
            }
            types.add(identifier.toString());
        }
        types.remove("extends");
        types.remove("implements");
        return types;
    }

    private static CharSequence withoutAnnotations(CharSequence chars) {
        StringBuilder result = new StringBuilder();
        StringBuilder identifier = new StringBuilder();
        AnnotationState state = AnnotationState.CODE;
        int depth = 0;
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            switch (state) {
                case CODE: {
                    if (c != '@') break;
                    state = AnnotationState.SYMBOL;
                    identifier.delete(0, identifier.length());
                    break;
                }
                case SYMBOL: {
                    if (Character.isJavaIdentifierStart(c)) {
                        state = AnnotationState.NAME;
                        identifier.append(c);
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    throw new IllegalStateException("Unexpected character " + c + " after @");
                }
                case NAME: {
                    if (Character.isWhitespace(c)) {
                        if ("interface".contentEquals(identifier)) {
                            result.append("@interface ");
                        }
                        state = AnnotationState.SPACE;
                        break;
                    }
                    if (c == '(') {
                        state = AnnotationState.BODY;
                        depth = 1;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) {
                        state = AnnotationState.CODE;
                        break;
                    }
                    identifier.append(c);
                    break;
                }
                case SPACE: {
                    if (c == '(') {
                        state = AnnotationState.BODY;
                        depth = 1;
                        break;
                    }
                    if (c == '.') {
                        state = AnnotationState.PERIOD;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    state = AnnotationState.CODE;
                    break;
                }
                case PERIOD: {
                    if (c == '(') {
                        throw new IllegalStateException("Unexpected ( after .");
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        state = AnnotationState.NAME;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    state = AnnotationState.CODE;
                    break;
                }
                case BODY: {
                    if (c == '(') {
                        ++depth;
                        break;
                    }
                    if (c != ')') break;
                    --depth;
                }
            }
            if (state == AnnotationState.CODE) {
                result.append(c);
                continue;
            }
            if (state != AnnotationState.BODY || depth != 0) continue;
            state = AnnotationState.CODE;
        }
        return result.toString();
    }

    private static CharSequence withoutTypeParams(CharSequence chars) {
        StringBuilder result = new StringBuilder();
        int depth = 0;
        block4: for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '<': {
                    ++depth;
                    continue block4;
                }
                case '>': {
                    if (--depth >= 0) continue block4;
                    return null;
                }
                default: {
                    if (depth != 0) continue block4;
                    result.append(c);
                }
            }
        }
        return result;
    }

    static enum AnnotationState {
        CODE,
        SYMBOL,
        NAME,
        SPACE,
        PERIOD,
        BODY;

    }

    private static enum State {
        CODE,
        SLASH,
        STRING_LITERAL,
        STRING_LITERAL_ESCAPE,
        CHAR_LITERAL,
        CHAR_LITERAL_ESCAPE,
        LINE_COMMENT,
        BLOCK_COMMENT,
        BLOCK_COMMENT_STAR;

    }

    static interface EventHandler {
        public void onPackageStatement(String var1);

        public void onTypeBlockStart(String var1, String var2, Set<String> var3);

        public void onMethodBlockStart(String var1, Set<String> var2);

        public void onOtherBlockStart();

        public void onBlockEnd();
    }
}

