/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.NameAndVisibility;
import org.inferred.freebuilder.processor.model.MethodFinder;
import org.inferred.freebuilder.processor.model.ModelUtils;

public class NamePicker {
    public static NameAndVisibility pickName(DeclaredType targetType, Elements elements, Types types, TypeMirror returnType, String preferredName, TypeMirror ... parameterTypes) {
        Map<String, ExecutableElement> methodsByName = MethodFinder.methodsOn(ModelUtils.asElement(targetType), elements, errorType -> {}).stream().filter(NamePicker.matchingErasedParameters(types, parameterTypes)).collect(NamePicker.byName());
        String name = preferredName;
        Datatype.Visibility visibility = Datatype.Visibility.PUBLIC;
        int attempt = 1;
        ExecutableElement method;
        while ((method = methodsByName.get(name)) != null) {
            boolean sufficientVisibility = !method.getModifiers().contains((Object)Modifier.PRIVATE);
            boolean correctSignature = NamePicker.parametersMatchExactly(types, method, parameterTypes);
            TypeMirror actualReturnType = ModelUtils.getReturnType(targetType, method, types);
            boolean correctReturnType = types.isSameType(actualReturnType, returnType);
            if (sufficientVisibility && correctSignature && correctReturnType) {
                if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    visibility = Datatype.Visibility.PACKAGE;
                }
                return NameAndVisibility.of(name, visibility);
            }
            name = "_" + preferredName + "Impl";
            visibility = Datatype.Visibility.PACKAGE;
            if (attempt > 1) {
                name = name + attempt;
            }
            ++attempt;
        }
        return NameAndVisibility.of(name, visibility);
    }

    private static Predicate<? super ExecutableElement> matchingErasedParameters(Types types, TypeMirror ... parameterTypes) {
        return method -> {
            if (method.getParameters().size() != parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                TypeMirror expectedErasedType;
                VariableElement parameter = method.getParameters().get(i);
                TypeMirror erasedType = types.erasure(parameterTypes[i]);
                if (types.isSameType(erasedType, expectedErasedType = types.erasure(parameter.asType()))) continue;
                return false;
            }
            return true;
        };
    }

    private static boolean parametersMatchExactly(Types types, ExecutableElement method, TypeMirror ... parameterTypes) {
        if (method.getParameters().size() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            VariableElement parameter = method.getParameters().get(i);
            if (types.isSameType(parameterTypes[i], parameter.asType())) continue;
            return false;
        }
        return true;
    }

    private static Collector<ExecutableElement, ?, Map<String, ExecutableElement>> byName() {
        return Collectors.toMap(method -> method.getSimpleName().toString(), method -> method);
    }
}

