package org.incendo.cloud.processors.confirmation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;
import org.incendo.cloud.context.CommandContext;

/**
 * Immutable implementation of {@link ConfirmationConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfirmationConfiguration.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConfirmationConfiguration.of()}.
 */
@Generated(from = "ConfirmationConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableConfirmationConfiguration<C>
    implements ConfirmationConfiguration<C> {
  private final org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache;
  private final java.util.function.@NonNull Consumer<C> noPendingCommandNotifier;
  private final java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier;
  private final java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation;
  private final java.time.@Nullable Duration expiration;

  private ImmutableConfirmationConfiguration(
      org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache,
      java.util.function.@NonNull Consumer<C> noPendingCommandNotifier,
      java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier,
      java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation,
      java.time.@Nullable Duration expiration) {
    this.cache = Objects.requireNonNull(cache, "cache");
    this.noPendingCommandNotifier = Objects.requireNonNull(noPendingCommandNotifier, "noPendingCommandNotifier");
    this.confirmationRequiredNotifier = Objects.requireNonNull(confirmationRequiredNotifier, "confirmationRequiredNotifier");
    this.bypassConfirmation = Objects.requireNonNull(bypassConfirmation, "bypassConfirmation");
    this.expiration = expiration;
    this.initShim = null;
  }

  private ImmutableConfirmationConfiguration(ImmutableConfirmationConfiguration.Builder<C> builder) {
    this.cache = builder.cache;
    this.noPendingCommandNotifier = builder.noPendingCommandNotifier;
    this.confirmationRequiredNotifier = builder.confirmationRequiredNotifier;
    if (builder.bypassConfirmationIsSet()) {
      initShim.bypassConfirmation(builder.bypassConfirmation);
    }
    if (builder.expirationIsSet()) {
      initShim.expiration(builder.expiration);
    }
    this.bypassConfirmation = initShim.bypassConfirmation();
    this.expiration = initShim.expiration();
    this.initShim = null;
  }

  private ImmutableConfirmationConfiguration(
      ImmutableConfirmationConfiguration<C> original,
      org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache,
      java.util.function.@NonNull Consumer<C> noPendingCommandNotifier,
      java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier,
      java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation,
      java.time.@Nullable Duration expiration) {
    this.cache = cache;
    this.noPendingCommandNotifier = noPendingCommandNotifier;
    this.confirmationRequiredNotifier = confirmationRequiredNotifier;
    this.bypassConfirmation = bypassConfirmation;
    this.expiration = expiration;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  private final class InitShim {
    private byte bypassConfirmationBuildStage = STAGE_UNINITIALIZED;
    private java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation;

    java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation() {
      if (bypassConfirmationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bypassConfirmationBuildStage == STAGE_UNINITIALIZED) {
        bypassConfirmationBuildStage = STAGE_INITIALIZING;
        this.bypassConfirmation = Objects.requireNonNull(bypassConfirmationInitialize(), "bypassConfirmation");
        bypassConfirmationBuildStage = STAGE_INITIALIZED;
      }
      return this.bypassConfirmation;
    }

    void bypassConfirmation(java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation) {
      this.bypassConfirmation = bypassConfirmation;
      bypassConfirmationBuildStage = STAGE_INITIALIZED;
    }

    private byte expirationBuildStage = STAGE_UNINITIALIZED;
    private java.time.@Nullable Duration expiration;

    java.time.@Nullable Duration expiration() {
      if (expirationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (expirationBuildStage == STAGE_UNINITIALIZED) {
        expirationBuildStage = STAGE_INITIALIZING;
        this.expiration = expirationInitialize();
        expirationBuildStage = STAGE_INITIALIZED;
      }
      return this.expiration;
    }

    void expiration(java.time.@Nullable Duration expiration) {
      this.expiration = expiration;
      expirationBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (bypassConfirmationBuildStage == STAGE_INITIALIZING) attributes.add("bypassConfirmation");
      if (expirationBuildStage == STAGE_INITIALIZING) attributes.add("expiration");
      return "Cannot build ConfirmationConfiguration, attribute initializers form cycle " + attributes;
    }
  }

  private java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmationInitialize() {
    return ConfirmationConfiguration.super.bypassConfirmation();
  }

  private java.time.@Nullable Duration expirationInitialize() {
    return ConfirmationConfiguration.super.expiration();
  }

  /**
   * Returns the cache used to store pending commands.
   * @return the cache
   */
  @Override
  public org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache() {
    return cache;
  }

  /**
   * Returns a consumer that gets invoked when a sender tries to invoke the confirmation handler
   * without having any pending commands.
   * @return notifier for no pending commands
   */
  @Override
  public java.util.function.@NonNull Consumer<C> noPendingCommandNotifier() {
    return noPendingCommandNotifier;
  }

  /**
   * Returns a consumer that gets invoked when a command requires confirmation.
   * @return notifier for commands that require confirmation
   */
  @Override
  public java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier() {
    return confirmationRequiredNotifier;
  }

  /**
   * Returns a predicate that determines whether the {@link CommandContext}
   * should bypass the confirmation requirement.
   * <p>The default implementation always returns {@code false}</p>
   * @return predicate that determines whether confirmation should be skipped
   */
  @Override
  public java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.bypassConfirmation()
        : this.bypassConfirmation;
  }

  /**
   * Returns the time to keep the pending commands for. This can be set to {@code null} to
   * not enforce an expiration time.
   * <p>It is recommended to configure the {@link #cache()} to match this value.</p>
   * <p>The default value is {@code null}.</p>
   * @return the expiration duration
   */
  @Override
  public java.time.@Nullable Duration expiration() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.expiration()
        : this.expiration;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationConfiguration#cache() cache} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cache
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfirmationConfiguration<C> withCache(org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> value) {
    if (this.cache == value) return this;
    org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> newValue = Objects.requireNonNull(value, "cache");
    return new ImmutableConfirmationConfiguration<>(
        this,
        newValue,
        this.noPendingCommandNotifier,
        this.confirmationRequiredNotifier,
        this.bypassConfirmation,
        this.expiration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationConfiguration#noPendingCommandNotifier() noPendingCommandNotifier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for noPendingCommandNotifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfirmationConfiguration<C> withNoPendingCommandNotifier(java.util.function.@NonNull Consumer<C> value) {
    if (this.noPendingCommandNotifier == value) return this;
    java.util.function.@NonNull Consumer<C> newValue = Objects.requireNonNull(value, "noPendingCommandNotifier");
    return new ImmutableConfirmationConfiguration<>(
        this,
        this.cache,
        newValue,
        this.confirmationRequiredNotifier,
        this.bypassConfirmation,
        this.expiration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationConfiguration#confirmationRequiredNotifier() confirmationRequiredNotifier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for confirmationRequiredNotifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfirmationConfiguration<C> withConfirmationRequiredNotifier(java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> value) {
    if (this.confirmationRequiredNotifier == value) return this;
    java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> newValue = Objects.requireNonNull(value, "confirmationRequiredNotifier");
    return new ImmutableConfirmationConfiguration<>(
        this,
        this.cache,
        this.noPendingCommandNotifier,
        newValue,
        this.bypassConfirmation,
        this.expiration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bypassConfirmation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfirmationConfiguration<C> withBypassConfirmation(java.util.function.@NonNull Predicate<CommandContext<C>> value) {
    if (this.bypassConfirmation == value) return this;
    java.util.function.@NonNull Predicate<CommandContext<C>> newValue = Objects.requireNonNull(value, "bypassConfirmation");
    return new ImmutableConfirmationConfiguration<>(
        this,
        this.cache,
        this.noPendingCommandNotifier,
        this.confirmationRequiredNotifier,
        newValue,
        this.expiration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationConfiguration#expiration() expiration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expiration (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfirmationConfiguration<C> withExpiration(java.time.@Nullable Duration value) {
    if (this.expiration == value) return this;
    return new ImmutableConfirmationConfiguration<>(
        this,
        this.cache,
        this.noPendingCommandNotifier,
        this.confirmationRequiredNotifier,
        this.bypassConfirmation,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfirmationConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfirmationConfiguration<?>
        && equalTo(0, (ImmutableConfirmationConfiguration<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableConfirmationConfiguration<?> another) {
    return cache.equals(another.cache)
        && noPendingCommandNotifier.equals(another.noPendingCommandNotifier)
        && confirmationRequiredNotifier.equals(another.confirmationRequiredNotifier)
        && bypassConfirmation.equals(another.bypassConfirmation)
        && Objects.equals(expiration, another.expiration);
  }

  /**
   * Computes a hash code from attributes: {@code cache}, {@code noPendingCommandNotifier}, {@code confirmationRequiredNotifier}, {@code bypassConfirmation}, {@code expiration}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + cache.hashCode();
    h += (h << 5) + noPendingCommandNotifier.hashCode();
    h += (h << 5) + confirmationRequiredNotifier.hashCode();
    h += (h << 5) + bypassConfirmation.hashCode();
    h += (h << 5) + Objects.hashCode(expiration);
    return h;
  }

  /**
   * Prints the immutable value {@code ConfirmationConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConfirmationConfiguration{"
        + "cache=" + cache
        + ", noPendingCommandNotifier=" + noPendingCommandNotifier
        + ", confirmationRequiredNotifier=" + confirmationRequiredNotifier
        + ", bypassConfirmation=" + bypassConfirmation
        + ", expiration=" + expiration
        + "}";
  }

  /**
   * Construct a new immutable {@code ConfirmationConfiguration} instance.
 * @param <C> generic parameter C
   * @param cache The value for the {@code cache} attribute
   * @param noPendingCommandNotifier The value for the {@code noPendingCommandNotifier} attribute
   * @param confirmationRequiredNotifier The value for the {@code confirmationRequiredNotifier} attribute
   * @param bypassConfirmation The value for the {@code bypassConfirmation} attribute
   * @param expiration The value for the {@code expiration} attribute
   * @return An immutable ConfirmationConfiguration instance
   */
  public static <C> ImmutableConfirmationConfiguration<C> of(org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache, java.util.function.@NonNull Consumer<C> noPendingCommandNotifier, java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier, java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation, java.time.@Nullable Duration expiration) {
    return new ImmutableConfirmationConfiguration<>(cache, noPendingCommandNotifier, confirmationRequiredNotifier, bypassConfirmation, expiration);
  }

  /**
   * Creates an immutable copy of a {@link ConfirmationConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <C> generic parameter C
   * @param instance The instance to copy
   * @return A copied immutable ConfirmationConfiguration instance
   */
  public static <C> ImmutableConfirmationConfiguration<C> copyOf(ConfirmationConfiguration<C> instance) {
    if (instance instanceof ImmutableConfirmationConfiguration<?>) {
      return (ImmutableConfirmationConfiguration<C>) instance;
    }
    return ((ImmutableConfirmationConfiguration.Builder<C>) ImmutableConfirmationConfiguration.<C>builder())
        .cache(instance.cache())
        .noPendingCommandNotifier(instance.noPendingCommandNotifier())
        .confirmationRequiredNotifier(instance.confirmationRequiredNotifier())
        .bypassConfirmation(instance.bypassConfirmation())
        .expiration(instance.expiration())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfirmationConfiguration ImmutableConfirmationConfiguration}.
   * <pre>
   * ImmutableConfirmationConfiguration.&amp;lt;C&amp;gt;builder()
   *    .cache(org.incendo.cloud.processors.cache.@org.checkerframework.checker.nullness.qual.NonNull CloudCache&amp;lt;C, org.incendo.cloud.processors.confirmation.ConfirmationContext&amp;lt;C&amp;gt;&amp;gt;) // required {@link ConfirmationConfiguration#cache() cache}
   *    .noPendingCommandNotifier(function.@org.checkerframework.checker.nullness.qual.NonNull Consumer&amp;lt;C&amp;gt;) // required {@link ConfirmationConfiguration#noPendingCommandNotifier() noPendingCommandNotifier}
   *    .confirmationRequiredNotifier(function.@org.checkerframework.checker.nullness.qual.NonNull BiConsumer&amp;lt;C, org.incendo.cloud.processors.confirmation.ConfirmationContext&amp;lt;C&amp;gt;&amp;gt;) // required {@link ConfirmationConfiguration#confirmationRequiredNotifier() confirmationRequiredNotifier}
   *    .bypassConfirmation(function.@org.checkerframework.checker.nullness.qual.NonNull Predicate&amp;lt;org.incendo.cloud.context.CommandContext&amp;lt;C&amp;gt;&amp;gt;) // optional {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation}
   *    .expiration(java.time.@org.checkerframework.checker.nullness.qual.Nullable Duration | null) // nullable {@link ConfirmationConfiguration#expiration() expiration}
   *    .build();
   * </pre>
   * @param <C> generic parameter C
   * @return A new ImmutableConfirmationConfiguration builder
   */
  public static <C> CacheBuildStage<C> builder() {
    return new ImmutableConfirmationConfiguration.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConfirmationConfiguration ImmutableConfirmationConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  public static final class Builder<C>
      implements CacheBuildStage<C>, NoPendingCommandNotifierBuildStage<C>, ConfirmationRequiredNotifierBuildStage<C>, BuildFinal<C> {
    private static final long INIT_BIT_CACHE = 0x1L;
    private static final long INIT_BIT_NO_PENDING_COMMAND_NOTIFIER = 0x2L;
    private static final long INIT_BIT_CONFIRMATION_REQUIRED_NOTIFIER = 0x4L;
    private static final long OPT_BIT_BYPASS_CONFIRMATION = 0x1L;
    private static final long OPT_BIT_EXPIRATION = 0x2L;
    private long initBits = 0x7L;
    private long optBits;

    private org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache;
    private java.util.function.@NonNull Consumer<C> noPendingCommandNotifier;
    private java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier;
    private java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation;
    private java.time.@Nullable Duration expiration;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#cache() cache} attribute.
     * @param cache The value for cache 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<C> cache(org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache) {
      checkNotIsSet(cacheIsSet(), "cache");
      this.cache = Objects.requireNonNull(cache, "cache");
      initBits &= ~INIT_BIT_CACHE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#noPendingCommandNotifier() noPendingCommandNotifier} attribute.
     * @param noPendingCommandNotifier The value for noPendingCommandNotifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<C> noPendingCommandNotifier(java.util.function.@NonNull Consumer<C> noPendingCommandNotifier) {
      checkNotIsSet(noPendingCommandNotifierIsSet(), "noPendingCommandNotifier");
      this.noPendingCommandNotifier = Objects.requireNonNull(noPendingCommandNotifier, "noPendingCommandNotifier");
      initBits &= ~INIT_BIT_NO_PENDING_COMMAND_NOTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#confirmationRequiredNotifier() confirmationRequiredNotifier} attribute.
     * @param confirmationRequiredNotifier The value for confirmationRequiredNotifier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<C> confirmationRequiredNotifier(java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier) {
      checkNotIsSet(confirmationRequiredNotifierIsSet(), "confirmationRequiredNotifier");
      this.confirmationRequiredNotifier = Objects.requireNonNull(confirmationRequiredNotifier, "confirmationRequiredNotifier");
      initBits &= ~INIT_BIT_CONFIRMATION_REQUIRED_NOTIFIER;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation}.</em>
     * @param bypassConfirmation The value for bypassConfirmation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<C> bypassConfirmation(java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation) {
      checkNotIsSet(bypassConfirmationIsSet(), "bypassConfirmation");
      this.bypassConfirmation = Objects.requireNonNull(bypassConfirmation, "bypassConfirmation");
      optBits |= OPT_BIT_BYPASS_CONFIRMATION;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#expiration() expiration} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConfirmationConfiguration#expiration() expiration}.</em>
     * @param expiration The value for expiration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<C> expiration(java.time.@Nullable Duration expiration) {
      checkNotIsSet(expirationIsSet(), "expiration");
      this.expiration = expiration;
      optBits |= OPT_BIT_EXPIRATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfirmationConfiguration ImmutableConfirmationConfiguration}.
     * @return An immutable instance of ConfirmationConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfirmationConfiguration<C> build() {
      checkRequiredAttributes();
      return new ImmutableConfirmationConfiguration<C>(this);
    }

    private boolean bypassConfirmationIsSet() {
      return (optBits & OPT_BIT_BYPASS_CONFIRMATION) != 0;
    }

    private boolean expirationIsSet() {
      return (optBits & OPT_BIT_EXPIRATION) != 0;
    }

    private boolean cacheIsSet() {
      return (initBits & INIT_BIT_CACHE) == 0;
    }

    private boolean noPendingCommandNotifierIsSet() {
      return (initBits & INIT_BIT_NO_PENDING_COMMAND_NOTIFIER) == 0;
    }

    private boolean confirmationRequiredNotifierIsSet() {
      return (initBits & INIT_BIT_CONFIRMATION_REQUIRED_NOTIFIER) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ConfirmationConfiguration is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!cacheIsSet()) attributes.add("cache");
      if (!noPendingCommandNotifierIsSet()) attributes.add("noPendingCommandNotifier");
      if (!confirmationRequiredNotifierIsSet()) attributes.add("confirmationRequiredNotifier");
      return "Cannot build ConfirmationConfiguration, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  public interface CacheBuildStage<C> {
    /**
     * Initializes the value for the {@link ConfirmationConfiguration#cache() cache} attribute.
     * @param cache The value for cache 
     * @return {@code this} builder for use in a chained invocation
     */
    NoPendingCommandNotifierBuildStage<C> cache(org.incendo.cloud.processors.cache.@NonNull CloudCache<C, ConfirmationContext<C>> cache);
  }

  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  public interface NoPendingCommandNotifierBuildStage<C> {
    /**
     * Initializes the value for the {@link ConfirmationConfiguration#noPendingCommandNotifier() noPendingCommandNotifier} attribute.
     * @param noPendingCommandNotifier The value for noPendingCommandNotifier 
     * @return {@code this} builder for use in a chained invocation
     */
    ConfirmationRequiredNotifierBuildStage<C> noPendingCommandNotifier(java.util.function.@NonNull Consumer<C> noPendingCommandNotifier);
  }

  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  public interface ConfirmationRequiredNotifierBuildStage<C> {
    /**
     * Initializes the value for the {@link ConfirmationConfiguration#confirmationRequiredNotifier() confirmationRequiredNotifier} attribute.
     * @param confirmationRequiredNotifier The value for confirmationRequiredNotifier 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal<C> confirmationRequiredNotifier(java.util.function.@NonNull BiConsumer<C, ConfirmationContext<C>> confirmationRequiredNotifier);
  }

  @Generated(from = "ConfirmationConfiguration", generator = "Immutables")
  public interface BuildFinal<C> {

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConfirmationConfiguration#bypassConfirmation() bypassConfirmation}.</em>
     * @param bypassConfirmation The value for bypassConfirmation 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal<C> bypassConfirmation(java.util.function.@NonNull Predicate<CommandContext<C>> bypassConfirmation);

    /**
     * Initializes the value for the {@link ConfirmationConfiguration#expiration() expiration} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConfirmationConfiguration#expiration() expiration}.</em>
     * @param expiration The value for expiration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal<C> expiration(java.time.@Nullable Duration expiration);

    /**
     * Builds a new {@link ImmutableConfirmationConfiguration ImmutableConfirmationConfiguration}.
     * @return An immutable instance of ConfirmationConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableConfirmationConfiguration<C> build();
  }
}
