package org.incendo.cloud.processors.confirmation;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConfirmationContext}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ConfirmationContextImpl.of()}.
 */
@Generated(from = "ConfirmationContext", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ConfirmationContextImpl<C>
    implements ConfirmationContext<C> {
  private final java.time.@NonNull Instant creationTime;
  private final org.incendo.cloud.@NonNull Command<C> command;
  private final org.incendo.cloud.context.@NonNull CommandContext<C> commandContext;

  private ConfirmationContextImpl(
      java.time.@NonNull Instant creationTime,
      org.incendo.cloud.@NonNull Command<C> command,
      org.incendo.cloud.context.@NonNull CommandContext<C> commandContext) {
    this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
    this.command = Objects.requireNonNull(command, "command");
    this.commandContext = Objects.requireNonNull(commandContext, "commandContext");
  }

  private ConfirmationContextImpl(
      ConfirmationContextImpl<C> original,
      java.time.@NonNull Instant creationTime,
      org.incendo.cloud.@NonNull Command<C> command,
      org.incendo.cloud.context.@NonNull CommandContext<C> commandContext) {
    this.creationTime = creationTime;
    this.command = command;
    this.commandContext = commandContext;
  }

  /**
   * @return The value of the {@code creationTime} attribute
   */
  @Override
  public java.time.@NonNull Instant creationTime() {
    return creationTime;
  }

  /**
   * @return The value of the {@code command} attribute
   */
  @Override
  public org.incendo.cloud.@NonNull Command<C> command() {
    return command;
  }

  /**
   * @return The value of the {@code commandContext} attribute
   */
  @Override
  public org.incendo.cloud.context.@NonNull CommandContext<C> commandContext() {
    return commandContext;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationContext#creationTime() creationTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creationTime
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationContextImpl<C> withCreationTime(java.time.@NonNull Instant value) {
    if (this.creationTime == value) return this;
    java.time.@NonNull Instant newValue = Objects.requireNonNull(value, "creationTime");
    return new ConfirmationContextImpl<>(this, newValue, this.command, this.commandContext);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationContext#command() command} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationContextImpl<C> withCommand(org.incendo.cloud.@NonNull Command<C> value) {
    if (this.command == value) return this;
    org.incendo.cloud.@NonNull Command<C> newValue = Objects.requireNonNull(value, "command");
    return new ConfirmationContextImpl<>(this, this.creationTime, newValue, this.commandContext);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationContext#commandContext() commandContext} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commandContext
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationContextImpl<C> withCommandContext(org.incendo.cloud.context.@NonNull CommandContext<C> value) {
    if (this.commandContext == value) return this;
    org.incendo.cloud.context.@NonNull CommandContext<C> newValue = Objects.requireNonNull(value, "commandContext");
    return new ConfirmationContextImpl<>(this, this.creationTime, this.command, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConfirmationContextImpl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ConfirmationContextImpl<?>
        && equalTo(0, (ConfirmationContextImpl<?>) another);
  }

  private boolean equalTo(int synthetic, ConfirmationContextImpl<?> another) {
    return creationTime.equals(another.creationTime)
        && command.equals(another.command)
        && commandContext.equals(another.commandContext);
  }

  /**
   * Computes a hash code from attributes: {@code creationTime}, {@code command}, {@code commandContext}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + creationTime.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + commandContext.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConfirmationContext} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConfirmationContext{"
        + "creationTime=" + creationTime
        + ", command=" + command
        + ", commandContext=" + commandContext
        + "}";
  }

  /**
   * Construct a new immutable {@code ConfirmationContext} instance.
 * @param <C> generic parameter C
   * @param creationTime The value for the {@code creationTime} attribute
   * @param command The value for the {@code command} attribute
   * @param commandContext The value for the {@code commandContext} attribute
   * @return An immutable ConfirmationContext instance
   */
  public static <C> ConfirmationContextImpl<C> of(java.time.@NonNull Instant creationTime, org.incendo.cloud.@NonNull Command<C> command, org.incendo.cloud.context.@NonNull CommandContext<C> commandContext) {
    return new ConfirmationContextImpl<>(creationTime, command, commandContext);
  }

  /**
   * Creates an immutable copy of a {@link ConfirmationContext} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <C> generic parameter C
   * @param instance The instance to copy
   * @return A copied immutable ConfirmationContext instance
   */
  public static <C> ConfirmationContextImpl<C> copyOf(ConfirmationContext<C> instance) {
    if (instance instanceof ConfirmationContextImpl<?>) {
      return (ConfirmationContextImpl<C>) instance;
    }
    return ConfirmationContextImpl.<C>of(instance.creationTime(), instance.command(), instance.commandContext());
  }
}
