//
// MIT License
//
// Copyright (c) 2024 Incendo
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
package org.incendo.cloud.paper.parser;

import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apiguardian.api.API;
import org.bukkit.NamespacedKey;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RegistryEntryParser.RegistryEntry}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code RegistryEntryImpl.of()}.
 */
@Generated(from = "RegistryEntryParser.RegistryEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@API(status = API.Status.INTERNAL, consumers = "org.incendo.cloud.*")
final class RegistryEntryImpl<E>
    implements RegistryEntryParser.RegistryEntry<E> {
  private final E value;
  private final NamespacedKey key;

  private RegistryEntryImpl(E value, NamespacedKey key) {
    this.value = Objects.requireNonNull(value, "value");
    this.key = Objects.requireNonNull(key, "key");
  }

  private RegistryEntryImpl(RegistryEntryImpl<E> original, E value, NamespacedKey key) {
    this.value = value;
    this.key = key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public E value() {
    return value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public NamespacedKey key() {
    return key;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryEntryParser.RegistryEntry#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final RegistryEntryImpl<E> withValue(E value) {
    if (this.value == value) return this;
    E newValue = Objects.requireNonNull(value, "value");
    return new RegistryEntryImpl<>(this, newValue, this.key);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryEntryParser.RegistryEntry#key() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final RegistryEntryImpl<E> withKey(NamespacedKey value) {
    if (this.key == value) return this;
    NamespacedKey newValue = Objects.requireNonNull(value, "key");
    return new RegistryEntryImpl<>(this, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code RegistryEntryImpl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof RegistryEntryImpl<?>
        && equalTo(0, (RegistryEntryImpl<?>) another);
  }

  private boolean equalTo(int synthetic, RegistryEntryImpl<?> another) {
    return value.equals(another.value)
        && key.equals(another.key);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code key}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + key.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RegistryEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RegistryEntry{"
        + "value=" + value
        + ", key=" + key
        + "}";
  }

  /**
   * Construct a new immutable {@code RegistryEntry} instance.
 * @param <E> generic parameter E
   * @param value The value for the {@code value} attribute
   * @param key The value for the {@code key} attribute
   * @return An immutable RegistryEntry instance
   */
  public static <E> RegistryEntryImpl<E> of(E value, NamespacedKey key) {
    return new RegistryEntryImpl<>(value, key);
  }

  /**
   * Creates an immutable copy of a {@link RegistryEntryParser.RegistryEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <E> generic parameter E
   * @param instance The instance to copy
   * @return A copied immutable RegistryEntry instance
   */
  public static <E> RegistryEntryImpl<E> copyOf(RegistryEntryParser.RegistryEntry<E> instance) {
    if (instance instanceof RegistryEntryImpl<?>) {
      return (RegistryEntryImpl<E>) instance;
    }
    return RegistryEntryImpl.<E>of(instance.value(), instance.key());
  }
}
