/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper.suggestion.tooltips;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.mojang.brigadier.Message;
import io.papermc.paper.brigadier.PaperBrigadier;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import org.incendo.cloud.paper.suggestion.tooltips.CompletionMapper;

final class ReflectiveCompletionMapper
implements CompletionMapper {
    private final MethodHandle completionWithTooltip;
    private final MethodHandle componentFromMessage;

    ReflectiveCompletionMapper() {
        Method componentFromMessageMethod = CraftBukkitReflection.needMethod(PaperBrigadier.class, (String)"componentFromMessage", (Class[])new Class[]{Message.class});
        Method completionWithTooltipMethod = CraftBukkitReflection.needMethod(AsyncTabCompleteEvent.Completion.class, (String)"completion", (Class[])new Class[]{String.class, componentFromMessageMethod.getReturnType()});
        try {
            this.componentFromMessage = MethodHandles.publicLookup().unreflect(componentFromMessageMethod);
            this.completionWithTooltip = MethodHandles.publicLookup().unreflect(completionWithTooltipMethod);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AsyncTabCompleteEvent.Completion map(@NonNull TooltipSuggestion suggestion) {
        Message tooltip = suggestion.tooltip();
        if (tooltip == null) {
            return AsyncTabCompleteEvent.Completion.completion((String)suggestion.suggestion());
        }
        try {
            Object component = this.componentFromMessage.invoke(tooltip);
            return this.completionWithTooltip.invoke(suggestion.suggestion(), component);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

