/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper.suggestion;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.BukkitPluginRegistrationHandler;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.paper.PaperCommandManager;
import org.incendo.cloud.paper.suggestion.SuggestionListener;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.Suggestions;
import org.incendo.cloud.util.StringUtils;

class AsyncCommandSuggestionListener<C>
implements SuggestionListener<C> {
    private final PaperCommandManager<C> paperCommandManager;

    AsyncCommandSuggestionListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
    }

    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        String commandLabel;
        String strippedBuffer;
        String string = strippedBuffer = event.getBuffer().startsWith("/") ? event.getBuffer().substring(1) : event.getBuffer();
        if (strippedBuffer.trim().isEmpty()) {
            return;
        }
        BukkitPluginRegistrationHandler bukkitPluginRegistrationHandler = (BukkitPluginRegistrationHandler)this.paperCommandManager.commandRegistrationHandler();
        if (!bukkitPluginRegistrationHandler.isRecognized(commandLabel = strippedBuffer.split(" ")[0])) {
            return;
        }
        this.setSuggestions(event, this.paperCommandManager.senderMapper().map((Object)event.getSender()), this.paperCommandManager.stripNamespace(event.getBuffer()));
        event.setHandled(true);
    }

    protected Suggestions<C, ?> querySuggestions(@NonNull C commandSender, @NonNull String input) {
        return this.paperCommandManager.suggestionFactory().suggestImmediately(commandSender, input);
    }

    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input) {
        Suggestions suggestions = this.querySuggestions(commandSender, input);
        event.setCompletions(suggestions.list().stream().map(Suggestion::suggestion).map(suggestion -> StringUtils.trimBeforeLastSpace((String)suggestion, (CommandInput)suggestions.commandInput())).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

