/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.paper;

import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.BrigadierSetting;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.BukkitCommandManager;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.PaperBrigadierListener;
import org.incendo.cloud.paper.PaperCommandPreprocessor;
import org.incendo.cloud.paper.suggestion.SuggestionListener;
import org.incendo.cloud.paper.suggestion.SuggestionListenerFactory;
import org.incendo.cloud.setting.Setting;
import org.incendo.cloud.state.RegistrationState;
import org.incendo.cloud.state.State;

public class PaperCommandManager<C>
extends BukkitCommandManager<C> {
    private @Nullable PaperBrigadierListener<C> paperBrigadierListener = null;

    @API(status=API.Status.STABLE, since="2.0.0")
    public PaperCommandManager(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSender, C> senderMapper) throws BukkitCommandManager.InitializationException {
        super(owningPlugin, commandExecutionCoordinator, senderMapper);
        this.registerCommandPreProcessor(new PaperCommandPreprocessor(this));
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static @NonNull PaperCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<CommandSender> commandExecutionCoordinator) throws BukkitCommandManager.InitializationException {
        return new PaperCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, SenderMapper.identity());
    }

    public void registerBrigadier() throws BukkitCommandManager.BrigadierInitializationException {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (!this.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            super.registerBrigadier();
        } else {
            try {
                this.paperBrigadierListener = new PaperBrigadierListener(this);
                Bukkit.getPluginManager().registerEvents(this.paperBrigadierListener, this.owningPlugin());
                this.paperBrigadierListener.brigadierManager().settings().set((Setting)BrigadierSetting.FORCE_EXECUTABLE, true);
            }
            catch (Exception e) {
                throw new BukkitCommandManager.BrigadierInitializationException("Failed to register " + PaperBrigadierListener.class.getSimpleName(), (Throwable)e);
            }
        }
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public boolean hasBrigadierManager() {
        return this.paperBrigadierListener != null || super.hasBrigadierManager();
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public @NonNull CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.paperBrigadierListener != null) {
            return this.paperBrigadierListener.brigadierManager();
        }
        return super.brigadierManager();
    }

    public void registerAsynchronousCompletions() throws IllegalStateException {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        if (!this.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            throw new IllegalStateException("Failed to register asynchronous command completion listener.");
        }
        SuggestionListenerFactory suggestionListenerFactory = SuggestionListenerFactory.create(this);
        SuggestionListener suggestionListener = suggestionListenerFactory.createListener();
        Bukkit.getServer().getPluginManager().registerEvents(suggestionListener, this.owningPlugin());
    }
}

