/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.parser.location;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.parser.location.LocationCoordinate;
import org.incendo.cloud.bukkit.parser.location.LocationCoordinateType;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.standard.DoubleParser;

public final class LocationCoordinateParser<C>
implements ArgumentParser<C, LocationCoordinate> {
    public @NonNull ArgumentParseResult<@NonNull LocationCoordinate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        double coordinate;
        LocationCoordinateType locationCoordinateType;
        String input = commandInput.skipWhitespace().peekString();
        if (commandInput.peek() == '^') {
            locationCoordinateType = LocationCoordinateType.LOCAL;
            commandInput.moveCursor(1);
        } else if (commandInput.peek() == '~') {
            locationCoordinateType = LocationCoordinateType.RELATIVE;
            commandInput.moveCursor(1);
        } else {
            locationCoordinateType = LocationCoordinateType.ABSOLUTE;
        }
        try {
            boolean empty = commandInput.peekString().isEmpty() || commandInput.peek() == ' ';
            double d = coordinate = empty ? 0.0 : commandInput.readDouble();
            if (commandInput.hasRemainingInput()) {
                commandInput.skipWhitespace();
            }
        }
        catch (Exception e) {
            return ArgumentParseResult.failure((Throwable)new DoubleParser.DoubleParseException(input, new DoubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), commandContext));
        }
        return ArgumentParseResult.success((Object)LocationCoordinate.of(locationCoordinateType, coordinate));
    }
}

