/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.parser;

import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.BukkitCaptionKeys;
import org.incendo.cloud.bukkit.BukkitCommandContextKeys;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class OfflinePlayerParser<C>
implements ArgumentParser<C, OfflinePlayer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, OfflinePlayer> offlinePlayerParser() {
        return ParserDescriptor.of(new OfflinePlayerParser<C>(), OfflinePlayer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, OfflinePlayer> offlinePlayerComponent() {
        return CommandComponent.builder().parser(OfflinePlayerParser.offlinePlayerParser());
    }

    public @NonNull ArgumentParseResult<OfflinePlayer> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        OfflinePlayer player;
        String input = commandInput.readString();
        if (input.length() > 16) {
            return ArgumentParseResult.failure((Throwable)((Object)new OfflinePlayerParseException(input, commandContext)));
        }
        try {
            player = Bukkit.getOfflinePlayer((String)input);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure((Throwable)((Object)new OfflinePlayerParseException(input, commandContext)));
        }
        return ArgumentParseResult.success((Object)player);
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        CommandSender bukkit = (CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        return Bukkit.getOnlinePlayers().stream().filter(player -> !(bukkit instanceof Player) || ((Player)bukkit).canSee(player)).map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    public static final class OfflinePlayerParseException
    extends ParserException {
        private final String input;

        public OfflinePlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(OfflinePlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_OFFLINEPLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

