/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.parser;

import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.BukkitCaptionKeys;
import org.incendo.cloud.bukkit.BukkitCommandContextKeys;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    public @NonNull ArgumentParseResult<Player> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = Bukkit.getPlayer((String)input);
        if (player == null) {
            return ArgumentParseResult.failure((Throwable)((Object)new PlayerParseException(input, commandContext)));
        }
        return ArgumentParseResult.success((Object)player);
    }

    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        CommandSender bukkit = (CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        return Bukkit.getOnlinePlayers().stream().filter(player -> !(bukkit instanceof Player) || ((Player)bukkit).canSee(player)).map(OfflinePlayer::getName).map(Suggestion::simple).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private final String input;

        public PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

