/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.parser;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.BukkitCaptionKeys;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.Suggestion;

public final class MaterialParser<C>
implements ArgumentParser<C, Material>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Material> materialParser() {
        return ParserDescriptor.of(new MaterialParser<C>(), Material.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, Material> materialComponent() {
        return CommandComponent.builder().parser(MaterialParser.materialParser());
    }

    public @NonNull ArgumentParseResult<Material> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        try {
            Material material = Material.valueOf((String)input.toUpperCase(Locale.ROOT));
            return ArgumentParseResult.success((Object)material);
        }
        catch (IllegalArgumentException exception) {
            return ArgumentParseResult.failure((Throwable)((Object)new MaterialParseException(input, commandContext)));
        }
    }

    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).map(Suggestion::simple).collect(Collectors.toList());
    }

    public static final class MaterialParseException
    extends ParserException {
        private final String input;

        public MaterialParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(MaterialParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_MATERIAL, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

