/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.brigadier.parser.WrappedBrigadierParser;
import org.incendo.cloud.bukkit.data.ProtoItemStack;
import org.incendo.cloud.bukkit.internal.CommandBuildContextSupplier;
import org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import org.incendo.cloud.bukkit.internal.MinecraftArgumentTypes;
import org.incendo.cloud.bukkit.parser.MaterialParser;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.suggestion.SuggestionProvider;

public class ItemStackParser<C>
implements ArgumentParser.FutureArgumentParser<C, ProtoItemStack> {
    private final ArgumentParser<C, ProtoItemStack> parser = ItemStackParser.findItemInputClass() != null ? new ModernParser() : new LegacyParser();

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, ProtoItemStack> itemStackParser() {
        return ParserDescriptor.of(new ItemStackParser<C>(), ProtoItemStack.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, ProtoItemStack> itemStackComponent() {
        return CommandComponent.builder().parser(ItemStackParser.itemStackParser());
    }

    private static @Nullable Class<?> findItemInputClass() {
        Class[] classes;
        for (Class clazz : classes = new Class[]{CraftBukkitReflection.findNMSClass("ArgumentPredicateItemStack"), CraftBukkitReflection.findMCClass("commands.arguments.item.ArgumentPredicateItemStack"), CraftBukkitReflection.findMCClass("commands.arguments.item.ItemInput")}) {
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public final @NonNull CompletableFuture<@NonNull ArgumentParseResult<ProtoItemStack>> parseFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        return this.parser.parseFuture(commandContext, commandInput);
    }

    public final @NonNull SuggestionProvider<C> suggestionProvider() {
        return this.parser.suggestionProvider();
    }

    static /* synthetic */ Class access$100() {
        return ItemStackParser.findItemInputClass();
    }

    private static final class ModernParser<C>
    implements ArgumentParser.FutureArgumentParser<C, ProtoItemStack> {
        private static final Class<?> NMS_ITEM_STACK_CLASS = CraftBukkitReflection.needNMSClassOrElse("ItemStack", "net.minecraft.world.item.ItemStack");
        private static final Class<?> CRAFT_ITEM_STACK_CLASS = CraftBukkitReflection.needOBCClass("inventory.CraftItemStack");
        private static final Class<?> ARGUMENT_ITEM_STACK_CLASS = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"item_stack"));
        private static final Class<?> ITEM_INPUT_CLASS = Objects.requireNonNull(ItemStackParser.access$100(), "ItemInput class");
        private static final Class<?> NMS_ITEM_CLASS = CraftBukkitReflection.needNMSClassOrElse("Item", "net.minecraft.world.item.Item");
        private static final Class<?> CRAFT_MAGIC_NUMBERS_CLASS = CraftBukkitReflection.needOBCClass("util.CraftMagicNumbers");
        private static final Method GET_MATERIAL_METHOD = CraftBukkitReflection.needMethod(CRAFT_MAGIC_NUMBERS_CLASS, "getMaterial", NMS_ITEM_CLASS);
        private static final Method CREATE_ITEM_STACK_METHOD = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find createItemStack method on ItemInput", CraftBukkitReflection.findMethod(ITEM_INPUT_CLASS, "a", Integer.TYPE, Boolean.TYPE), CraftBukkitReflection.findMethod(ITEM_INPUT_CLASS, "createItemStack", Integer.TYPE, Boolean.TYPE));
        private static final Method AS_BUKKIT_COPY_METHOD = CraftBukkitReflection.needMethod(CRAFT_ITEM_STACK_CLASS, "asBukkitCopy", NMS_ITEM_STACK_CLASS);
        private static final Field ITEM_FIELD = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find item field on ItemInput", CraftBukkitReflection.findField(ITEM_INPUT_CLASS, "b"), CraftBukkitReflection.findField(ITEM_INPUT_CLASS, "item"));
        private static final Field COMPOUND_TAG_FIELD = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find tag field on ItemInput", CraftBukkitReflection.findField(ITEM_INPUT_CLASS, "c"), CraftBukkitReflection.findField(ITEM_INPUT_CLASS, "tag"));
        private static final Class<?> HOLDER_CLASS = CraftBukkitReflection.findMCClass("core.Holder");
        private static final @Nullable Method VALUE_METHOD = HOLDER_CLASS == null ? null : CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find Holder#value", CraftBukkitReflection.findMethod(HOLDER_CLASS, "value", new Class[0]), CraftBukkitReflection.findMethod(HOLDER_CLASS, "a", new Class[0]));
        private final ArgumentParser<C, ProtoItemStack> parser;

        ModernParser() {
            try {
                this.parser = this.createParser();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to initialize modern ItemStack parser.", ex);
            }
        }

        private ArgumentParser<C, ProtoItemStack> createParser() throws ReflectiveOperationException {
            Constructor<?> ctr = ARGUMENT_ITEM_STACK_CLASS.getDeclaredConstructors()[0];
            ArgumentType inst = ctr.getParameterCount() == 0 ? (ArgumentType)ctr.newInstance(new Object[0]) : (ArgumentType)ctr.newInstance(CommandBuildContextSupplier.commandBuildContext());
            return new WrappedBrigadierParser(inst).flatMapSuccess((ctx, itemInput) -> ArgumentParseResult.successFuture((Object)new ModernProtoItemStack(itemInput)));
        }

        public @NonNull CompletableFuture<@NonNull ArgumentParseResult<@NonNull ProtoItemStack>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
            return this.parser.parseFuture(commandContext, commandInput);
        }

        public @NonNull SuggestionProvider<C> suggestionProvider() {
            return this.parser.suggestionProvider();
        }

        private static final class ModernProtoItemStack
        implements ProtoItemStack {
            private final Object itemInput;
            private final Material material;
            private final @Nullable String snbt;

            ModernProtoItemStack(@NonNull Object itemInput) {
                this.itemInput = itemInput;
                try {
                    Object item = ITEM_FIELD.get(itemInput);
                    if (HOLDER_CLASS != null && HOLDER_CLASS.isInstance(item)) {
                        item = VALUE_METHOD.invoke(item, new Object[0]);
                    }
                    this.material = (Material)GET_MATERIAL_METHOD.invoke(null, item);
                    Object compoundTag = COMPOUND_TAG_FIELD.get(itemInput);
                    this.snbt = compoundTag != null ? compoundTag.toString() : null;
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public @NonNull Material material() {
                return this.material;
            }

            @Override
            public boolean hasExtraData() {
                return this.snbt != null;
            }

            @Override
            public @NonNull ItemStack createItemStack(int stackSize, boolean respectMaximumStackSize) {
                try {
                    return (ItemStack)AS_BUKKIT_COPY_METHOD.invoke(null, CREATE_ITEM_STACK_METHOD.invoke(this.itemInput, stackSize, respectMaximumStackSize));
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof CommandSyntaxException) {
                        throw new IllegalArgumentException(cause.getMessage(), cause);
                    }
                    throw new RuntimeException(ex);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static final class LegacyParser<C>
    implements ArgumentParser.FutureArgumentParser<C, ProtoItemStack>,
    BlockingSuggestionProvider.Strings<C> {
        private final ArgumentParser<C, ProtoItemStack> parser = new MaterialParser().mapSuccess((ctx, material) -> CompletableFuture.completedFuture(new LegacyProtoItemStack((Material)material)));

        private LegacyParser() {
        }

        public @NonNull CompletableFuture<@NonNull ArgumentParseResult<@NonNull ProtoItemStack>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
            return this.parser.parseFuture(commandContext, commandInput);
        }

        public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
            return Arrays.stream(Material.values()).filter(Material::isItem).map(value -> value.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        }

        private static final class LegacyProtoItemStack
        implements ProtoItemStack {
            private final Material material;

            private LegacyProtoItemStack(@NonNull Material material) {
                this.material = material;
            }

            @Override
            public @NonNull Material material() {
                return this.material;
            }

            @Override
            public boolean hasExtraData() {
                return false;
            }

            @Override
            public @NonNull ItemStack createItemStack(int stackSize, boolean respectMaximumStackSize) throws IllegalArgumentException {
                if (respectMaximumStackSize && stackSize > this.material.getMaxStackSize()) {
                    throw new IllegalArgumentException(String.format("The maximum stack size for %s is %d", this.material, this.material.getMaxStackSize()));
                }
                return new ItemStack(this.material, stackSize);
            }
        }
    }
}

