/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit.internal;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.apiguardian.api.API;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.BukkitCommandManager;
import org.incendo.cloud.bukkit.internal.CommandBuildContextSupplier;
import org.incendo.cloud.bukkit.internal.MinecraftArgumentTypes;
import org.incendo.cloud.bukkit.internal.RegistryReflection;
import org.incendo.cloud.bukkit.parser.BlockPredicateParser;
import org.incendo.cloud.bukkit.parser.EnchantmentParser;
import org.incendo.cloud.bukkit.parser.ItemStackParser;
import org.incendo.cloud.bukkit.parser.ItemStackPredicateParser;
import org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import org.incendo.cloud.bukkit.parser.location.Location2DParser;
import org.incendo.cloud.bukkit.parser.location.LocationParser;
import org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import org.incendo.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import org.incendo.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.standard.UUIDParser;

@API(status=API.Status.INTERNAL)
public final class BukkitBrigadierMapper<C> {
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager<C, ?> brigadierManager;

    public BukkitBrigadierMapper(@NonNull BukkitCommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, ?> brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
    }

    public void registerBuiltInMappings() {
        try {
            Class<? extends ArgumentType<?>> uuid = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"uuid"));
            this.mapSimpleNMS(new TypeToken<UUIDParser<C>>(){}, "uuid");
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        this.mapSimpleNMS(new TypeToken<NamespacedKeyParser<C>>(){}, "resource_location", true);
        try {
            Class<? extends ArgumentType<?>> ench = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"item_enchantment"));
            this.mapSimpleNMS(new TypeToken<EnchantmentParser<C>>(){}, "item_enchantment");
        }
        catch (IllegalArgumentException ignore) {
            this.mapResourceKey(new TypeToken<EnchantmentParser<C>>(){}, "enchantment");
        }
        this.mapSimpleNMS(new TypeToken<ItemStackParser<C>>(){}, "item_stack");
        this.mapSimpleNMS(new TypeToken<ItemStackPredicateParser<C>>(){}, "item_predicate");
        this.mapSimpleNMS(new TypeToken<BlockPredicateParser<C>>(){}, "block_predicate");
        this.mapSelector(new TypeToken<SingleEntitySelectorParser<C>>(){}, true, false);
        this.mapSelector(new TypeToken<SinglePlayerSelectorParser<C>>(){}, true, true);
        this.mapSelector(new TypeToken<MultipleEntitySelectorParser<C>>(){}, false, false);
        this.mapSelector(new TypeToken<MultiplePlayerSelectorParser<C>>(){}, false, true);
        this.mapNMS(new TypeToken<LocationParser<C>>(){}, "vec3", this::argumentVec3);
        this.mapNMS(new TypeToken<Location2DParser<C>>(){}, "vec2", this::argumentVec2);
    }

    private <T extends ArgumentParser<C, ?>> void mapResourceKey(@NonNull TypeToken<T> parserType, @NonNull String registryName) {
        this.mapNMS(parserType, "resource_key", type -> (ArgumentType)type.getDeclaredConstructors()[0].newInstance(RegistryReflection.registryKey(RegistryReflection.registryByName(registryName))));
    }

    private <T extends ArgumentParser<C, ?>> void mapSelector(@NonNull TypeToken<T> parserType, boolean single, boolean playersOnly) {
        this.mapNMS(parserType, "entity", argumentTypeCls -> {
            Constructor<?> constructor = argumentTypeCls.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return (ArgumentType)constructor.newInstance(single, playersOnly);
        });
    }

    private @NonNull ArgumentType<?> argumentVec3(Class<? extends ArgumentType<?>> type) throws ReflectiveOperationException {
        return type.getDeclaredConstructor(Boolean.TYPE).newInstance(true);
    }

    private @NonNull ArgumentType<?> argumentVec2(Class<? extends ArgumentType<?>> type) throws ReflectiveOperationException {
        return type.getDeclaredConstructor(Boolean.TYPE).newInstance(true);
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId) {
        this.mapSimpleNMS(type, argumentId, false);
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId, boolean useCloudSuggestions) {
        this.mapNMS(type, argumentId, cls -> {
            Object[] objectArray;
            Constructor<?> ctr = cls.getDeclaredConstructors()[0];
            if (ctr.getParameterCount() == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = CommandBuildContextSupplier.commandBuildContext();
            } else {
                objectArray = new Object[]{};
            }
            Object[] args = objectArray;
            return (ArgumentType)ctr.newInstance(args);
        }, useCloudSuggestions);
    }

    public <T extends ArgumentParser<C, ?>> void mapNMS(@NonNull TypeToken<T> type, @NonNull String argumentId, @NonNull ArgumentTypeFactory factory) {
        this.mapNMS(type, argumentId, factory, false);
    }

    public <T extends ArgumentParser<C, ?>> void mapNMS(@NonNull TypeToken<T> type, @NonNull String argumentId, @NonNull ArgumentTypeFactory factory, boolean cloudSuggestions) {
        Class<? extends ArgumentType<?>> argumentTypeClass;
        try {
            argumentTypeClass = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)argumentId));
        }
        catch (Exception e) {
            this.commandManager.owningPlugin().getLogger().log(Level.WARNING, "Failed to locate class for " + argumentId, e);
            return;
        }
        this.brigadierManager.registerMapping(type, builder -> {
            builder.to(argument -> {
                try {
                    return factory.makeInstance(argumentTypeClass);
                }
                catch (Exception e) {
                    this.commandManager.owningPlugin().getLogger().log(Level.WARNING, "Failed to create instance of " + argumentId + ", falling back to StringArgumentType.word()", e);
                    return StringArgumentType.word();
                }
            });
            if (cloudSuggestions) {
                builder.cloudSuggestions();
            }
        });
    }

    @API(status=API.Status.INTERNAL)
    @FunctionalInterface
    public static interface ArgumentTypeFactory {
        public ArgumentType<?> makeInstance(Class<? extends ArgumentType<?>> var1) throws ReflectiveOperationException;
    }
}

