/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Level;
import org.apiguardian.api.API;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.SenderMapperHolder;
import org.incendo.cloud.brigadier.BrigadierManagerHolder;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.BukkitCommandPreprocessor;
import org.incendo.cloud.bukkit.BukkitDefaultCaptionsProvider;
import org.incendo.cloud.bukkit.BukkitParserParameters;
import org.incendo.cloud.bukkit.BukkitPluginRegistrationHandler;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.bukkit.CloudBukkitListener;
import org.incendo.cloud.bukkit.CloudCommodoreManager;
import org.incendo.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import org.incendo.cloud.bukkit.annotation.specifier.DefaultNamespace;
import org.incendo.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import org.incendo.cloud.bukkit.data.MultipleEntitySelector;
import org.incendo.cloud.bukkit.data.MultiplePlayerSelector;
import org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import org.incendo.cloud.bukkit.parser.BlockPredicateParser;
import org.incendo.cloud.bukkit.parser.EnchantmentParser;
import org.incendo.cloud.bukkit.parser.ItemStackParser;
import org.incendo.cloud.bukkit.parser.ItemStackPredicateParser;
import org.incendo.cloud.bukkit.parser.MaterialParser;
import org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import org.incendo.cloud.bukkit.parser.PlayerParser;
import org.incendo.cloud.bukkit.parser.WorldParser;
import org.incendo.cloud.bukkit.parser.location.Location2DParser;
import org.incendo.cloud.bukkit.parser.location.LocationParser;
import org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import org.incendo.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import org.incendo.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.NoSuchCommandException;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.parser.ParserParameters;
import org.incendo.cloud.state.RegistrationState;
import org.incendo.cloud.state.State;

public abstract class BukkitCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C, Object>,
SenderMapperHolder<CommandSender, C> {
    private static final String MESSAGE_INTERNAL_ERROR = ChatColor.RED + "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = ChatColor.RED + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final Plugin owningPlugin;
    private final SenderMapper<CommandSender, C> senderMapper;
    private boolean splitAliases = false;

    @API(status=API.Status.INTERNAL, since="2.0.0")
    protected BukkitCommandManager(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSender, C> senderMapper) throws InitializationException {
        super(commandExecutionCoordinator, new BukkitPluginRegistrationHandler());
        try {
            ((BukkitPluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        }
        catch (ReflectiveOperationException exception) {
            throw new InitializationException("Failed to initialize command registration handler", exception);
        }
        this.owningPlugin = owningPlugin;
        this.senderMapper = senderMapper;
        CloudBukkitCapabilities.CAPABLE.forEach(x$0 -> this.registerCapability((CloudCapability)x$0));
        this.registerCapability((CloudCapability)CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
        this.registerCommandPreProcessor(new BukkitCommandPreprocessor(this));
        this.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        this.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, (Object)annotation.value()));
        this.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser((Boolean)parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, (Object)true)));
        this.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser((Boolean)parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, (Object)true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            this.registerParserSupplierFor(NamespacedKeyParser.class);
            this.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, (Object)true));
            this.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, (Object)annotation.value()));
        }
        if (this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.registerParserSupplierFor(ItemStackPredicateParser.class);
            this.registerParserSupplierFor(BlockPredicateParser.class);
        }
        this.owningPlugin.getServer().getPluginManager().registerEvents(new CloudBukkitListener(this), this.owningPlugin);
        this.registerDefaultExceptionHandlers();
        this.captionRegistry().registerProvider(new BukkitDefaultCaptionsProvider());
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public final @NonNull Plugin owningPlugin() {
        return this.owningPlugin;
    }

    public final @NonNull SenderMapper<CommandSender, C> senderMapper() {
        return this.senderMapper;
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return ((CommandSender)this.senderMapper.reverse(sender)).hasPermission(permission);
    }

    @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
    protected final boolean splitAliases() {
        return this.splitAliases;
    }

    @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
    protected final void splitAliases(boolean value) {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        this.splitAliases = value;
    }

    protected final void checkBrigadierCompatibility() throws BrigadierInitializationException {
        if (!this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            throw new BrigadierInitializationException("Missing capability " + CloudBukkitCapabilities.class.getSimpleName() + "." + (Object)((Object)CloudBukkitCapabilities.BRIGADIER) + " (Minecraft version too old? Brigadier was added in 1.13). See the Javadocs for more details");
        }
    }

    public void registerBrigadier() throws BrigadierInitializationException {
        this.requireState((State)RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (!this.hasCapability(CloudBukkitCapabilities.COMMODORE_BRIGADIER)) {
            throw new BrigadierInitializationException("Missing capability " + CloudBukkitCapabilities.class.getSimpleName() + "." + (Object)((Object)CloudBukkitCapabilities.COMMODORE_BRIGADIER) + " (Minecraft version too new). See the Javadocs for more details");
        }
        try {
            CloudCommodoreManager cloudCommodoreManager = new CloudCommodoreManager(this);
            cloudCommodoreManager.initialize(this);
            this.commandRegistrationHandler(cloudCommodoreManager);
            this.splitAliases(true);
        }
        catch (Exception e) {
            throw new BrigadierInitializationException("Unexpected exception initializing " + CloudCommodoreManager.class.getSimpleName(), e);
        }
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public boolean hasBrigadierManager() {
        return this.commandRegistrationHandler() instanceof CloudCommodoreManager;
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public @NonNull CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.commandRegistrationHandler() instanceof CloudCommodoreManager) {
            return ((CloudCommodoreManager)this.commandRegistrationHandler()).brigadierManager();
        }
        throw new BrigadierManagerHolder.BrigadierManagerNotPresent("The CloudBrigadierManager is either not supported in the current environment, or it is not enabled.");
    }

    @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
    public final @NonNull String stripNamespace(@NonNull String command) {
        String namespace;
        @NonNull String input = command.charAt(0) == '/' ? command.substring(1) : command;
        if (input.startsWith(namespace = String.format("%s:", this.owningPlugin().getName().toLowerCase(Locale.ROOT)))) {
            input = input.substring(namespace.length());
        }
        return input;
    }

    private void registerParserSupplierFor(@NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", BukkitCommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, new Object[]{this});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerDefaultExceptionHandlers() {
        this.exceptionController().registerHandler(Throwable.class, context -> {
            ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(MESSAGE_INTERNAL_ERROR);
            this.owningPlugin.getLogger().log(Level.SEVERE, "An unhandled exception was thrown during command execution", context.exception());
        }).registerHandler(CommandExecutionException.class, context -> {
            ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(MESSAGE_INTERNAL_ERROR);
            this.owningPlugin.getLogger().log(Level.SEVERE, "Exception executing command handler", ((CommandExecutionException)context.exception()).getCause());
        }).registerHandler(ArgumentParseException.class, context -> ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(ChatColor.RED + "Invalid Command Argument: " + ChatColor.GRAY + ((ArgumentParseException)context.exception()).getCause().getMessage())).registerHandler(NoSuchCommandException.class, context -> ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(MESSAGE_UNKNOWN_COMMAND)).registerHandler(NoPermissionException.class, context -> ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(MESSAGE_NO_PERMS)).registerHandler(InvalidCommandSenderException.class, context -> ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(ChatColor.RED + ((InvalidCommandSenderException)context.exception()).getMessage())).registerHandler(InvalidSyntaxException.class, context -> ((CommandSender)this.senderMapper.reverse(context.context().sender())).sendMessage(ChatColor.RED + "Invalid Command Syntax. Correct command syntax is: " + ChatColor.GRAY + ((InvalidSyntaxException)context.exception()).correctSyntax()));
    }

    final void lockIfBrigadierCapable() {
        if (this.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.lockRegistration();
        }
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static final class InitializationException
    extends IllegalStateException {
        @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
        public InitializationException(String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static final class BrigadierInitializationException
    extends IllegalStateException {
        @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
        public BrigadierInitializationException(@NonNull String reason) {
            super(reason);
        }

        @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
        public BrigadierInitializationException(@NonNull String reason, @Nullable Throwable cause) {
            super(reason, cause);
        }
    }
}

