/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.bukkit;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.Command;
import org.incendo.cloud.bukkit.BukkitCommandManager;
import org.incendo.cloud.bukkit.BukkitCommandMeta;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.description.CommandDescription;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.Suggestions;
import org.incendo.cloud.util.StringUtils;

final class BukkitCommand<C>
extends org.bukkit.command.Command
implements PluginIdentifiableCommand {
    private final CommandComponent<C> command;
    private final BukkitCommandManager<C> manager;
    private final Command<C> cloudCommand;
    private boolean disabled;

    private static @NonNull String description(@NonNull Command<?> command) {
        Optional bukkitDescription = command.commandMeta().optional(BukkitCommandMeta.BUKKIT_DESCRIPTION);
        if (bukkitDescription.isPresent()) {
            return (String)bukkitDescription.get();
        }
        CommandDescription description = command.commandDescription();
        if (!description.isEmpty()) {
            return description.description().textDescription();
        }
        return command.rootComponent().description().textDescription();
    }

    BukkitCommand(@NonNull String label, @NonNull List<@NonNull String> aliases, @NonNull Command<C> cloudCommand, @NonNull CommandComponent<C> command, @NonNull BukkitCommandManager<C> manager) {
        super(label, BukkitCommand.description(cloudCommand), "", aliases);
        this.command = command;
        this.manager = manager;
        this.cloudCommand = cloudCommand;
        this.disabled = false;
    }

    public @NonNull List<@NonNull String> tabComplete(@NonNull CommandSender sender, @NonNull String alias, @NonNull String @NonNull [] args) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder(this.command.name());
        for (String string : args) {
            builder.append(" ").append(string);
        }
        Suggestions result = this.manager.suggestionFactory().suggestImmediately(this.manager.senderMapper().map((Object)sender), builder.toString());
        return result.list().stream().map(Suggestion::suggestion).map(suggestion -> StringUtils.trimBeforeLastSpace((String)suggestion, (CommandInput)result.commandInput())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean execute(@NonNull CommandSender commandSender, @NonNull String commandLabel, @NonNull String @NonNull [] strings) {
        StringBuilder builder = new StringBuilder(this.command.name());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        Object sender = this.manager.senderMapper().map((Object)commandSender);
        this.manager.commandExecutor().executeCommand(sender, builder.toString());
        return true;
    }

    public @NonNull String getDescription() {
        return BukkitCommand.description(this.cloudCommand);
    }

    public @NonNull Plugin getPlugin() {
        return this.manager.owningPlugin();
    }

    public @NonNull String getUsage() {
        return this.manager.commandSyntaxFormatter().apply(null, Collections.singletonList(Objects.requireNonNull(this.namedNode().component())), this.namedNode());
    }

    public boolean testPermissionSilent(@NonNull CommandSender target) {
        CommandNode<C> node = this.namedNode();
        if (this.disabled || node == null) {
            return false;
        }
        Permission permission = node.nodeMeta().getOrDefault("permission", Permission.empty());
        return this.manager.testPermission(this.manager.senderMapper().map((Object)target), permission).allowed();
    }

    @API(status=API.Status.INTERNAL, since="1.7.0")
    void disable() {
        this.disabled = true;
    }

    public boolean isRegistered() {
        return !this.disabled;
    }

    private @Nullable CommandNode<C> namedNode() {
        return this.manager.commandTree().getNamedNode(this.command.name());
    }
}

