/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier.suggestion;

import com.mojang.brigadier.Message;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.suggestion.Suggestion;

@API(status=API.Status.STABLE, since="2.0.0")
public interface TooltipSuggestion
extends Suggestion {
    public static @NonNull TooltipSuggestion tooltipSuggestion(@NonNull String suggestion, @Nullable Message tooltip) {
        return new TooltipSuggestionImpl(suggestion, tooltip);
    }

    public static @NonNull TooltipSuggestion tooltipSuggestion(@NonNull Suggestion suggestion) {
        if (suggestion instanceof TooltipSuggestion) {
            return (TooltipSuggestion)suggestion;
        }
        return TooltipSuggestion.tooltipSuggestion(suggestion.suggestion(), null);
    }

    public @Nullable Message tooltip();

    default public @NonNull TooltipSuggestion withSuggestion(@NonNull String string) {
        return TooltipSuggestion.tooltipSuggestion(string, this.tooltip());
    }

    default public @NonNull TooltipSuggestion withTooltip(@NonNull Message tooltip) {
        return TooltipSuggestion.tooltipSuggestion(this.suggestion(), tooltip);
    }

    public static final class TooltipSuggestionImpl
    implements TooltipSuggestion {
        private final String suggestion;
        private final Message tooltip;

        private TooltipSuggestionImpl(@NonNull String suggestion, @Nullable Message tooltip) {
            this.suggestion = suggestion;
            this.tooltip = tooltip;
        }

        public @NonNull String suggestion() {
            return this.suggestion;
        }

        @Override
        public @Nullable Message tooltip() {
            return this.tooltip;
        }
    }
}

