/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier.suggestion;

import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.suggestion.SuggestionFactory;
import org.incendo.cloud.type.tuple.Pair;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierSuggestionFactory<C, S> {
    private final CloudBrigadierManager<C, S> cloudBrigadierManager;
    private final CommandManager<C> commandManager;
    private final Supplier<CommandContext<C>> dummyContextProvider;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    public BrigadierSuggestionFactory(@NonNull CloudBrigadierManager<C, S> cloudBrigadierManager, @NonNull CommandManager<C> commandManager, @NonNull Supplier<CommandContext<C>> dummyContextProvider, @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory) {
        this.cloudBrigadierManager = cloudBrigadierManager;
        this.commandManager = commandManager;
        this.dummyContextProvider = dummyContextProvider;
        this.suggestionFactory = suggestionFactory;
    }

    public @NonNull CompletableFuture<@NonNull Suggestions> buildSuggestions(@Nullable com.mojang.brigadier.context.CommandContext<S> senderContext, @Nullable CommandNode<C> parentNode, @NonNull CommandComponent<C> component, @NonNull SuggestionsBuilder builder) {
        String leading;
        CommandContext commandContext;
        String command = builder.getInput();
        if (senderContext == null) {
            commandContext = this.dummyContextProvider.get();
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
        } else {
            Object cloudSender = this.cloudBrigadierManager.senderMapper().map(senderContext.getSource());
            commandContext = new CommandContext(true, cloudSender, this.commandManager);
            command = command.substring(((StringRange)BrigadierSuggestionFactory.getNodes(senderContext.getLastChild()).get(0).second()).getStart());
        }
        if ((leading = command.split(" ")[0]).contains(":")) {
            command = command.substring(leading.split(":")[0].length() + 1);
        }
        return this.suggestionFactory.suggest(commandContext.sender(), command).thenApply(suggestionsResult -> {
            ArrayList<TooltipSuggestion> suggestions = new ArrayList<TooltipSuggestion>(suggestionsResult.list());
            if (parentNode != null) {
                Set siblingLiterals = parentNode.children().stream().map(CommandNode::component).filter(Objects::nonNull).filter(c -> c.type() == CommandComponent.ComponentType.LITERAL).flatMap(commandComponent -> commandComponent.aliases().stream()).collect(Collectors.toSet());
                suggestions.removeIf(suggestion -> siblingLiterals.contains(suggestion.suggestion()));
            }
            int trimmed = builder.getInput().length() - suggestionsResult.commandInput().length();
            int rawOffset = suggestionsResult.commandInput().cursor();
            SuggestionsBuilder suggestionsBuilder = builder.createOffset(rawOffset + trimmed);
            for (TooltipSuggestion suggestion2 : suggestions) {
                suggestionsBuilder.suggest(suggestion2.suggestion(), suggestion2.tooltip());
            }
            return suggestionsBuilder.build();
        });
    }

    private static <S> List<Pair<com.mojang.brigadier.tree.CommandNode<S>, StringRange>> getNodes(com.mojang.brigadier.context.CommandContext<S> commandContext) {
        try {
            Method getNodesMethod = commandContext.getClass().getDeclaredMethod("getNodes", new Class[0]);
            Object nodes = getNodesMethod.invoke(commandContext, new Object[0]);
            if (nodes instanceof List) {
                return ParsedCommandNodeHandler.toPairList((List)nodes);
            }
            if (nodes instanceof Map) {
                return ((Map)nodes).entrySet().stream().map(entry -> Pair.of((Object)((com.mojang.brigadier.tree.CommandNode)entry.getKey()), (Object)((StringRange)entry.getValue()))).collect(Collectors.toList());
            }
            throw new IllegalStateException();
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class ParsedCommandNodeHandler {
        private ParsedCommandNodeHandler() {
        }

        private static <S> List<Pair<com.mojang.brigadier.tree.CommandNode<S>, StringRange>> toPairList(List<?> nodes) {
            return nodes.stream().map(n -> Pair.of((Object)n.getNode(), (Object)n.getRange())).collect(Collectors.toList());
        }
    }
}

