/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.types;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TimeInstant
implements Comparable<TimeInstant> {
    private final long value;

    private TimeInstant(long instant) {
        this.value = instant;
    }

    public static TimeInstant of(long instant) {
        return new TimeInstant(instant);
    }

    public long value() {
        return this.value;
    }

    public TimeUnit unit() {
        return TimeUnit.MILLISECONDS;
    }

    public boolean isBefore(TimeInstant that) {
        return this.compareTo(that) < 0;
    }

    public boolean isAfter(TimeInstant that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public int compareTo(TimeInstant that) {
        return Longs.compare((long)this.value, (long)that.value);
    }

    public boolean equals(Object that) {
        return that instanceof TimeInstant && ((TimeInstant)that).value == this.value;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.value).toString();
    }
}

