/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.concurrent.FluentFutures;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;

public final class Repositories {
    private static final int LARGE_BATCH_SIZE = 2000;

    private Repositories() {
    }

    @NotThreadSafe
    public static abstract class Finder<T, F extends Finder<T, F>>
    extends Operation<T> {
        int numberToSkip;
        @Nullable
        protected Constraints.ConstraintHost criteria;
        protected Constraints.Constraint ordering = Constraints.nilConstraint();
        protected Constraints.Constraint exclusion = Constraints.nilConstraint();

        protected Finder(Repository<T> repository) {
            super(repository);
        }

        public F skip(@Nonnegative int numberToSkip) {
            Preconditions.checkArgument((numberToSkip >= 0 ? 1 : 0) != 0, (Object)"number to skip cannot be negative");
            this.numberToSkip = numberToSkip;
            return (F)this;
        }

        public final FluentFuture<List<T>> fetchWithLimit(@Nonnegative int limitSize) {
            Preconditions.checkArgument((limitSize >= 0 ? 1 : 0) != 0, (Object)"limit cannot be negative");
            return this.repository.doFetch(this.criteria, this.ordering, this.exclusion, this.numberToSkip, limitSize);
        }

        public final FluentFuture<List<T>> fetchAll() {
            return this.fetchWithLimit(0);
        }

        public final FluentFuture<Optional<T>> fetchFirst() {
            return this.fetchWithLimit(1).transform(new Function<List<T>, Optional<T>>(){

                public Optional<T> apply(List<T> input) {
                    return FluentIterable.from(input).first();
                }
            });
        }
    }

    @NotThreadSafe
    public static abstract class FinderWithDelete<T, F extends Finder<T, F>>
    extends Finder<T, F> {
        protected FinderWithDelete(Repository<T> repository) {
            super(repository);
        }

        public FluentFuture<Integer> deleteAll() {
            Preconditions.checkState((this.numberToSkip == 0 ? 1 : 0) != 0, (Object)"Cannot use .skip() with .deleteAll()");
            return this.repository.doDelete(this.criteria);
        }

        public FluentFuture<Optional<T>> deleteFirst() {
            Preconditions.checkState((this.numberToSkip == 0 ? 1 : 0) != 0, (Object)"Cannot use .skip() with .deleteFirst()");
            FindOneAndDeleteOptions options = new FindOneAndDeleteOptions();
            options.sort(Support.convertToBson(this.ordering));
            return this.repository.doFindOneAndDelete(this.criteria, options);
        }
    }

    @NotThreadSafe
    public static abstract class Indexer<T, I extends Indexer<T, I>>
    extends Operation<T> {
        protected Constraints.Constraint fields = Constraints.nilConstraint();
        private final IndexOptions options = new IndexOptions();

        protected Indexer(Repository<T> repository) {
            super(repository);
        }

        public final I named(String indexName) {
            this.options.name(indexName);
            return (I)this;
        }

        public final I unique() {
            this.options.unique(true);
            return (I)this;
        }

        public final I expireAfterSeconds(int timeToLiveSeconds) {
            this.options.expireAfter(Long.valueOf(timeToLiveSeconds), TimeUnit.SECONDS);
            return (I)this;
        }

        public final FluentFuture<Void> ensure() {
            return this.repository.doIndex(this.fields, this.options);
        }
    }

    @NotThreadSafe
    public static abstract class Replacer<T, M extends Replacer<T, M>>
    extends UpdatatingOperation<T> {
        private final FindOneAndReplaceOptions options;
        private final T document;
        private final Constraints.ConstraintHost criteria;
        private final Constraints.Constraint ordering;

        protected Replacer(Repository<T> repository, T document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super(repository);
            this.document = Preconditions.checkNotNull(document, (Object)"document");
            this.criteria = (Constraints.ConstraintHost)Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            this.ordering = (Constraints.Constraint)Preconditions.checkNotNull((Object)ordering, (Object)"ordering");
            this.options = new FindOneAndReplaceOptions();
        }

        public final M returningOld() {
            this.options.returnDocument(ReturnDocument.BEFORE);
            return (M)this;
        }

        public final M returningNew() {
            this.options.returnDocument(ReturnDocument.AFTER);
            return (M)this;
        }

        public final FluentFuture<Optional<T>> upsert() {
            this.options.upsert(true);
            this.options.sort(Support.convertToBson(this.ordering));
            return this.repository.doReplace(this.criteria, this.document, this.options);
        }

        public final FluentFuture<Optional<T>> update() {
            this.options.sort(Support.convertToBson(this.ordering));
            return this.repository.doReplace(this.criteria, this.document, this.options);
        }
    }

    @NotThreadSafe
    public static abstract class Modifier<T, M extends Modifier<T, M>>
    extends UpdatatingOperation<T> {
        protected Constraints.Constraint ordering = Constraints.nilConstraint();
        protected Constraints.Constraint exclusion = Constraints.nilConstraint();
        private final FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();

        protected Modifier(Repository<T> repository) {
            super(repository);
        }

        public final M returningOld() {
            this.options.returnDocument(ReturnDocument.BEFORE);
            return (M)this;
        }

        public final M returningNew() {
            this.options.returnDocument(ReturnDocument.AFTER);
            return (M)this;
        }

        public final FluentFuture<Optional<T>> upsert() {
            this.options.upsert(true);
            this.options.sort(Support.convertToBson(this.ordering));
            return this.repository.doModify(this.criteria, this.collectRequiredUpdate(), this.options);
        }

        public final FluentFuture<Optional<T>> update() {
            this.options.sort(Support.convertToBson(this.ordering));
            return this.repository.doModify(this.criteria, this.collectRequiredUpdate(), this.options);
        }
    }

    @NotThreadSafe
    public static abstract class Updater<T>
    extends UpdatatingOperation<T> {
        protected Updater(Repository<T> repository) {
            super(repository);
        }

        public FluentFuture<Integer> upsert() {
            UpdateOptions options = new UpdateOptions();
            options.upsert(true);
            return this.repository.doUpdate(this.criteria, this.collectRequiredUpdate(), options);
        }

        public FluentFuture<Integer> updateFirst() {
            return this.repository.doUpdateFirst(this.criteria, this.collectRequiredUpdate(), new FindOneAndUpdateOptions());
        }

        public FluentFuture<Integer> updateAll() {
            return this.repository.doUpdate(this.criteria, this.collectRequiredUpdate(), new UpdateOptions());
        }
    }

    @NotThreadSafe
    static abstract class UpdatatingOperation<T>
    extends Operation<T> {
        @Nullable
        protected Constraints.ConstraintHost criteria;
        protected Constraints.Constraint setFields = Constraints.nilConstraint();
        protected Constraints.Constraint setOnInsertFields = Constraints.nilConstraint();
        protected Constraints.Constraint incrementFields = Constraints.nilConstraint();
        protected Constraints.Constraint addToSetFields = Constraints.nilConstraint();
        protected Constraints.Constraint pushFields = Constraints.nilConstraint();
        protected Constraints.Constraint pullFields = Constraints.nilConstraint();
        protected Constraints.Constraint unsetFields = Constraints.nilConstraint();

        protected UpdatatingOperation(Repository<T> repository) {
            super(repository);
        }

        protected Constraints.Constraint collectRequiredUpdate() {
            Constraints.Constraint update = this.collectUpdate();
            Preconditions.checkState((!update.isNil() ? 1 : 0) != 0);
            return update;
        }

        protected Constraints.Constraint collectUpdate() {
            Constraints.Constraint update = Constraints.nilConstraint();
            update = this.appendFields(update, "$set", this.setFields);
            update = this.appendFields(update, "$setOnInsert", this.setOnInsertFields);
            update = this.appendFields(update, "$inc", this.incrementFields);
            update = this.appendFields(update, "$addToSet", this.addToSetFields);
            update = this.appendFields(update, "$push", this.pushFields);
            update = this.appendFields(update, "$pull", this.pullFields);
            update = this.appendFields(update, "$unset", this.unsetFields);
            return update;
        }

        private Constraints.Constraint appendFields(Constraints.Constraint fields, String name, Constraints.Constraint setOfFields) {
            return !setOfFields.isNil() ? fields.equal(name, false, setOfFields) : fields;
        }
    }

    @NotThreadSafe
    static abstract class Operation<T> {
        protected final Repository<T> repository;

        protected Operation(Repository<T> repository) {
            this.repository = repository;
        }
    }

    @ThreadSafe
    public static abstract class Criteria {
        public abstract Criteria or();
    }

    @ThreadSafe
    public static abstract class Repository<T> {
        private final RepositorySetup configuration;
        private final MongoCollection<T> collection;
        private final RepositorySetup.FieldNamingStrategy fieldNamingStrategy;

        protected Repository(RepositorySetup configuration, String collectionName, Class<T> type) {
            this.configuration = (RepositorySetup)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
            Preconditions.checkNotNull((Object)collectionName, (Object)"collectionName");
            Preconditions.checkNotNull(type, (Object)"type");
            MongoCollection collection = configuration.database.getCollection(collectionName, type);
            this.collection = collection.withCodecRegistry(configuration.codecRegistry);
            this.fieldNamingStrategy = configuration.fieldNamingStrategy;
        }

        protected final CodecRegistry codecRegistry() {
            return this.collection.getCodecRegistry();
        }

        protected final RepositorySetup.FieldNamingStrategy fieldNamingStrategy() {
            return this.fieldNamingStrategy;
        }

        private MongoCollection<T> collection() {
            return this.collection;
        }

        private <V> FluentFuture<V> submit(Callable<V> callable) {
            return FluentFutures.from(this.configuration.executor.submit(callable));
        }

        protected final FluentFuture<Void> doIndex(final Constraints.Constraint fields, final IndexOptions options) {
            return this.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    Repository.this.collection().createIndex(Support.convertToIndex(fields), options);
                    return null;
                }
            });
        }

        protected final FluentFuture<Integer> doInsert(final ImmutableList<T> documents) {
            if (documents.isEmpty()) {
                return FluentFutures.from(Futures.immediateFuture((Object)0));
            }
            return this.submit(new Callable<Integer>(){

                @Override
                public Integer call() {
                    Repository.this.collection().insertMany((List)documents);
                    return 0;
                }
            });
        }

        protected final FluentFuture<Optional<T>> doReplace(final Constraints.ConstraintHost criteria, final T document, final FindOneAndReplaceOptions options) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull(document, (Object)"document");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return this.submit(new Callable<Optional<T>>(){

                @Override
                public Optional<T> call() throws Exception {
                    Object result = Repository.this.collection().findOneAndReplace(Support.convertToBson(criteria), document, options);
                    return Optional.fromNullable((Object)result);
                }
            });
        }

        protected final FluentFuture<Optional<T>> doModify(final Constraints.ConstraintHost criteria, final Constraints.Constraint update, final FindOneAndUpdateOptions options) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull((Object)update, (Object)"update");
            return this.submit(new Callable<Optional<T>>(){

                @Override
                public Optional<T> call() throws Exception {
                    Object result = Repository.this.collection().findOneAndUpdate(Support.convertToBson(criteria), Support.convertToBson(update), options);
                    return Optional.fromNullable((Object)result);
                }
            });
        }

        protected final FluentFuture<Optional<T>> doFindOneAndDelete(final Constraints.ConstraintHost criteria, final FindOneAndDeleteOptions options) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return this.submit(new Callable<Optional<T>>(){

                @Override
                public Optional<T> call() throws Exception {
                    Object result = Repository.this.collection().findOneAndDelete(Support.convertToBson(criteria), options);
                    return Optional.fromNullable((Object)result);
                }
            });
        }

        protected final FluentFuture<Integer> doUpdateFirst(final Constraints.ConstraintHost criteria, final Constraints.Constraint update, final FindOneAndUpdateOptions options) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull((Object)update, (Object)"update");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return this.submit(new Callable<Integer>(){

                @Override
                public Integer call() {
                    Object result = Repository.this.collection().findOneAndUpdate(Support.convertToBson(criteria), Support.convertToBson(update), options);
                    return result == null ? 0 : 1;
                }
            });
        }

        protected final FluentFuture<Integer> doUpdate(final Constraints.ConstraintHost criteria, final Constraints.Constraint update, final UpdateOptions options) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull((Object)update, (Object)"update");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return this.submit(new Callable<UpdateResult>(){

                @Override
                public UpdateResult call() {
                    return Repository.this.collection().updateMany(Support.convertToBson(criteria), Support.convertToBson(update), options);
                }
            }).lazyTransform(new Function<UpdateResult, Integer>(){

                public Integer apply(UpdateResult input) {
                    return (int)input.getModifiedCount();
                }
            });
        }

        protected final FluentFuture<Integer> doDelete(final Constraints.ConstraintHost criteria) {
            Preconditions.checkNotNull((Object)criteria);
            return this.submit(new Callable<DeleteResult>(){

                @Override
                public DeleteResult call() {
                    return Repository.this.collection().deleteMany(Support.convertToBson(criteria));
                }
            }).lazyTransform(new Function<DeleteResult, Integer>(){

                public Integer apply(DeleteResult input) {
                    return (int)input.getDeletedCount();
                }
            });
        }

        protected final FluentFuture<Integer> doUpsert(final Constraints.ConstraintHost criteria, final T document) {
            Preconditions.checkNotNull((Object)criteria, (Object)"criteria");
            Preconditions.checkNotNull(document, (Object)"document");
            return this.submit(new Callable<Integer>(){

                @Override
                public Integer call() {
                    Repository.this.collection().replaceOne(Support.convertToBson(criteria), document, new UpdateOptions().upsert(true));
                    return 1;
                }
            });
        }

        protected final FluentFuture<List<T>> doFetch(final @Nullable Constraints.ConstraintHost criteria, final Constraints.Constraint ordering, final Constraints.Constraint exclusion, final @Nonnegative int skip, final @Nonnegative int limit) {
            return this.submit(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    Bson query = criteria != null ? Support.convertToBson(criteria) : null;
                    FindIterable cursor = Repository.this.collection().find(query);
                    if (!exclusion.isNil()) {
                        cursor.projection(Support.convertToBson(exclusion));
                    }
                    if (!ordering.isNil()) {
                        cursor.sort(Support.convertToBson(ordering));
                    }
                    cursor.skip(skip);
                    if (limit != 0) {
                        cursor.limit(limit);
                        if (limit <= 2000) {
                            cursor.batchSize(-limit);
                        }
                    }
                    try (MongoCursor iterator = cursor.iterator();){
                        ImmutableList immutableList = ImmutableList.copyOf((Iterator)iterator);
                        return immutableList;
                    }
                }
            });
        }
    }
}

