/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4gson;

import com.google.common.base.Preconditions;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.types.Decimal128;
import org.immutables.mongo.Wrapper;

@NotThreadSafe
public class BsonWriter
extends JsonWriter
implements Wrapper<org.bson.BsonWriter> {
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        @Override
        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        @Override
        public void flush() throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private final org.bson.BsonWriter delegate;

    BsonWriter(org.bson.BsonWriter delegate) {
        super(UNWRITABLE_WRITER);
        this.delegate = (org.bson.BsonWriter)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public org.bson.BsonWriter unwrap() {
        return this.delegate;
    }

    public JsonWriter beginArray() throws IOException {
        this.delegate.writeStartArray();
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.delegate.writeEndArray();
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.delegate.writeStartDocument();
        return this;
    }

    public JsonWriter endObject() throws IOException {
        this.delegate.writeEndDocument();
        return this;
    }

    public JsonWriter name(String name) throws IOException {
        this.delegate.writeName(name);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        this.delegate.writeString(value);
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        throw new UnsupportedOperationException("Can't write directly JSON to BSON");
    }

    public JsonWriter nullValue() throws IOException {
        this.delegate.writeNull();
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.delegate.writeBoolean(value);
        return this;
    }

    public JsonWriter value(Boolean value) throws IOException {
        if (value == null) {
            this.delegate.writeNull();
        } else {
            this.delegate.writeBoolean(value.booleanValue());
        }
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        this.delegate.writeDouble(value);
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.delegate.writeInt64(value);
        return this;
    }

    public JsonWriter value(int value) {
        this.delegate.writeInt32(value);
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (value instanceof Double) {
            return this.value(value.doubleValue());
        }
        if (value instanceof Float) {
            return this.value(value.floatValue());
        }
        if (value instanceof Long) {
            return this.value(value.longValue());
        }
        if (value instanceof Integer) {
            return this.value(value.intValue());
        }
        if (value instanceof Short) {
            return this.value(value.shortValue());
        }
        if (value instanceof Byte) {
            return this.value(value.byteValue());
        }
        if (value instanceof LazilyParsedNumber) {
            return this.value(value.longValue());
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            try {
                return this.value(new Decimal128(decimal));
            }
            catch (NumberFormatException ex) {
                return this.value(decimal.toPlainString());
            }
        }
        if (value instanceof BigInteger) {
            BigInteger integer = (BigInteger)value;
            try {
                BigDecimal decimal = new BigDecimal(integer);
                return this.value(new Decimal128(decimal));
            }
            catch (NumberFormatException ex) {
                return this.value(integer.toString());
            }
        }
        return this.value(value.doubleValue());
    }

    private JsonWriter value(Decimal128 decimal) {
        this.delegate.writeDecimal128(decimal);
        return this;
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        if (this.delegate instanceof Closeable) {
            ((Closeable)this.delegate).close();
        }
    }
}

