/*
 * Decompiled with CFR 0.152.
 */
package org.hydev.logger.appenders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.hydev.logger.HyLoggerConfig;
import org.hydev.logger.HyLoggerUtilsKt;
import org.hydev.logger.appenders.Appender;
import org.hydev.logger.appenders.LogData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/hydev/logger/appenders/FileAppender;", "Lorg/hydev/logger/appenders/Appender;", "path", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "fileWriter", "Ljava/io/PrintWriter;", "getFileWriter", "()Ljava/io/PrintWriter;", "setFileWriter", "(Ljava/io/PrintWriter;)V", "logRaw", "", "message", "HyLogger"})
public class FileAppender
extends Appender {
    @NotNull
    private PrintWriter fileWriter;

    @NotNull
    public final PrintWriter getFileWriter() {
        return this.fileWriter;
    }

    public final void setFileWriter(@NotNull PrintWriter printWriter) {
        Intrinsics.checkParameterIsNotNull((Object)printWriter, (String)"<set-?>");
        this.fileWriter = printWriter;
    }

    @Override
    public void logRaw(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.fileWriter.write(HyLoggerUtilsKt.withoutFormat(message) + "\n");
        this.fileWriter.flush();
    }

    public FileAppender(@NotNull File file) {
        PrintWriter printWriter;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(null, 1, null);
        this.setFormatter((Function1<? super LogData, String>)((Function1)1.INSTANCE));
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            file.createNewFile();
        }
        File file2 = file;
        FileAppender fileAppender = this;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        File file3 = file2;
        int n = 8192;
        boolean bl2 = false;
        Object object = file3;
        boolean bl3 = false;
        Object object2 = object;
        boolean bl4 = false;
        object2 = new FileOutputStream((File)object2);
        bl4 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        bl3 = false;
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        fileAppender.fileWriter = printWriter = new PrintWriter(writer);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                this.getFileWriter().flush();
                this.getFileWriter().close();
            }
        }));
    }

    public FileAppender(@NotNull String path, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this(new File(new File(path), StringsKt.replace$default((String)StringsKt.replace$default((String)HyLoggerConfig.INSTANCE.getFileFormat(), (String)"{name}", (String)name, (boolean)false, (int)4, null), (String)"{time}", (String)HyLoggerUtilsKt.now(HyLoggerConfig.INSTANCE.getFileTimePattern()), (boolean)false, (int)4, null)));
    }
}

