/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;

public class NativeArrayBuffer
extends ScriptableObject {
    private static final long serialVersionUID = 3110411773054879549L;
    public static final String CLASS_NAME = "ArrayBuffer";
    private static final byte[] EMPTY_BUF = new byte[0];
    final byte[] buffer;

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, 2, NativeArrayBuffer::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.defineConstructorMethod(scope, "isView", 1, NativeArrayBuffer::js_isView, 2, 3);
        constructor.definePrototypeMethod(scope, "slice", 2, (lcx, lscope, thisObj, args) -> NativeArrayBuffer.js_slice(lcx, lscope, thisObj, constructor, args), 2, 3);
        constructor.definePrototypeProperty(cx, "byteLength", NativeArrayBuffer::js_byteLength, 3);
        ScriptableObject.defineProperty(scope, CLASS_NAME, constructor, 2);
        if (sealed) {
            constructor.sealObject();
        }
    }

    public NativeArrayBuffer() {
        this.buffer = EMPTY_BUF;
    }

    public NativeArrayBuffer(double len) {
        if (len >= 2.147483647E9) {
            throw ScriptRuntime.rangeError("length parameter (" + len + ") is too large ");
        }
        if (len == Double.NEGATIVE_INFINITY) {
            throw ScriptRuntime.rangeError("Negative array length " + len);
        }
        if (len <= -1.0) {
            throw ScriptRuntime.rangeError("Negative array length " + len);
        }
        int intLen = ScriptRuntime.toInt32(len);
        if (intLen < 0) {
            throw ScriptRuntime.rangeError("Negative array length " + len);
        }
        this.buffer = intLen == 0 ? EMPTY_BUF : new byte[intLen];
    }

    public int getLength() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public NativeArrayBuffer slice(double s, double e) {
        int end = ScriptRuntime.toInt32(Math.max(0.0, Math.min((double)this.buffer.length, e < 0.0 ? (double)this.buffer.length + e : e)));
        int start = ScriptRuntime.toInt32(Math.min((double)end, Math.max(0.0, s < 0.0 ? (double)this.buffer.length + s : s)));
        int len = end - start;
        NativeArrayBuffer newBuf = new NativeArrayBuffer(len);
        System.arraycopy(this.buffer, start, newBuf.buffer, 0, len);
        return newBuf;
    }

    private static NativeArrayBuffer getSelf(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeArrayBuffer.class);
    }

    private static NativeArrayBuffer js_constructor(Context cx, Scriptable scope, Object[] args) {
        double length = NativeArrayBuffer.isArg(args, 0) ? ScriptRuntime.toNumber(args[0]) : 0.0;
        return new NativeArrayBuffer(length);
    }

    private static Boolean js_isView(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeArrayBuffer.isArg(args, 0) && args[0] instanceof NativeArrayBufferView;
    }

    private static NativeArrayBuffer js_slice(Context cx, Scriptable scope, Scriptable thisObj, LambdaConstructor defaultConstructor, Object[] args) {
        NativeArrayBuffer self = NativeArrayBuffer.getSelf(thisObj);
        double start = NativeArrayBuffer.isArg(args, 0) ? ScriptRuntime.toNumber(args[0]) : 0.0;
        double end = NativeArrayBuffer.isArg(args, 1) ? ScriptRuntime.toNumber(args[1]) : (double)self.getLength();
        int endI = ScriptRuntime.toInt32(Math.max(0.0, Math.min((double)self.getLength(), end < 0.0 ? (double)self.getLength() + end : end)));
        int startI = ScriptRuntime.toInt32(Math.min((double)endI, Math.max(0.0, start < 0.0 ? (double)self.getLength() + start : start)));
        int len = endI - startI;
        Constructable constructor = AbstractEcmaObjectOperations.speciesConstructor(cx, thisObj, defaultConstructor);
        Scriptable newBuf = constructor.construct(cx, scope, new Object[]{len});
        if (!(newBuf instanceof NativeArrayBuffer)) {
            throw ScriptRuntime.typeErrorById("msg.species.invalid.ctor", new Object[0]);
        }
        NativeArrayBuffer buf = (NativeArrayBuffer)newBuf;
        if (buf == self) {
            throw ScriptRuntime.typeErrorById("msg.arraybuf.same", new Object[0]);
        }
        int actualLength = buf.getLength();
        if (actualLength < len) {
            throw ScriptRuntime.typeErrorById("msg.arraybuf.smaller.len", len, actualLength);
        }
        System.arraycopy(self.buffer, startI, buf.buffer, 0, len);
        return buf;
    }

    private static Object js_byteLength(Scriptable thisObj) {
        return NativeArrayBuffer.getSelf(thisObj).getLength();
    }

    private static boolean isArg(Object[] args, int i) {
        return args.length > i && !Undefined.instance.equals(args[i]);
    }
}

