/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoPoint;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoMultiPoint
extends AbstractGeoJsonObject {
    public static final String TYPE = "MultiPoint";
    private List<GeoPoint> points;

    public GeoMultiPoint(GeoPoint point) {
        super(TYPE);
        Contracts.assertNotNull((Object)point, (String)"point");
        this.points.add(point);
    }

    public GeoMultiPoint(List<GeoPoint> points) {
        super(TYPE);
        Contracts.assertNotNull(points, (String)"points");
        this.points = points;
    }

    public GeoMultiPoint(GeoPoint firstPoint, GeoPoint ... additionalPoints) {
        super(TYPE);
        Contracts.assertNotNull((Object)firstPoint, (String)"firstPoint");
        Contracts.assertNotNull((Object)additionalPoints, (String)"additionalPoints");
        this.points = new ArrayList<Object>(Arrays.asList(ArrayHelper.concat((Object)firstPoint, (Object[])additionalPoints)));
    }

    public GeoMultiPoint addPoint(GeoPoint point) {
        Contracts.assertNotNull((Object)point, (String)"point");
        this.points.add(point);
        return this;
    }

    public List<GeoPoint> getPoints() {
        return this.points;
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        for (GeoPoint geoPoint : this.points) {
            coordinates.add((BsonValue)geoPoint.toCoordinates());
        }
        return coordinates;
    }

    public static GeoMultiPoint fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoMultiPoint.checkType(TYPE, document);
        List pointsCoordinates = (List)document.get((Object)"coordinates");
        if (pointsCoordinates == null) {
            return null;
        }
        List<GeoPoint> geoPoints = pointsCoordinates.stream().map(GeoPoint::fromCoordinates).collect(Collectors.toList());
        return new GeoMultiPoint(geoPoints);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoMultiPoint that = (GeoMultiPoint)obj;
        return that.points.equals(this.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        return "GeoMultiPoint [points=" + this.points + "]";
    }
}

