/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl;

import org.bson.json.JsonReader;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;

@BuildParseTree
public class NativeQueryParser
extends BaseParser<MongoDBQueryDescriptorBuilder> {
    public Rule Query() {
        return this.Sequence(this.push(new MongoDBQueryDescriptorBuilder()), this.Optional(this.CliQueryOrJsonFindQuery()), new Object[0]);
    }

    public Rule CliQueryOrJsonFindQuery() {
        return this.Sequence(this.FirstOf(this.ParsedQuery(), this.CriteriaOnlyFindQuery(), new Object[0]), ((MongoDBQueryDescriptorBuilder)this.peek()).setQueryValid(true), new Object[]{EOI});
    }

    public Rule ParsedQuery() {
        return this.Sequence(this.Db(), this.Collection(), new Object[]{this.Operation()});
    }

    public Rule CriteriaOnlyFindQuery() {
        return this.Sequence(!((MongoDBQueryDescriptorBuilder)this.peek()).isCliQuery(), this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.FIND), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match())});
    }

    @SuppressNode
    public Rule Db() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()), "db ", new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setCliQuery(true), this.Separator()});
    }

    @SuppressSubnodes
    public Rule Collection() {
        return this.Sequence(this.PathExpression(), ((MongoDBQueryDescriptorBuilder)this.peek()).setCollection(this.match()), new Object[]{this.Separator()});
    }

    public Rule PathExpression() {
        return this.Sequence(this.Ident(), this.ZeroOrMore(this.Separator(), this.Ident(), new Object[]{this.TestNot("( ")}), new Object[0]);
    }

    @SuppressSubnodes
    public Rule Ident() {
        return this.Sequence(this.IdentCharacter(), this.ZeroOrMore(this.FirstOf(this.IdentCharacter(), this.Digit(), new Object[0])), new Object[]{this.ZeroOrMore(this.WhiteSpace())});
    }

    @SuppressNode
    public Rule Separator() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()), ". ", new Object[0]);
    }

    public Rule Reserved() {
        return this.FirstOf(this.Find(), this.FindOne(), new Object[]{this.FindAndModify(), this.Insert(), this.InsertOne(), this.InsertMany(), this.Remove(), this.DeleteOne(), this.DeleteMany(), this.Update(), this.UpdateOne(), this.UpdateMany(), this.ReplaceOne(), this.Count(), this.Aggregate(), this.Distinct(), this.MapReduce()});
    }

    public Rule Operation() {
        return this.FirstOf(this.Find(), this.FindOne(), new Object[]{this.FindAndModify(), this.Insert(), this.InsertOne(), this.InsertMany(), this.Remove(), this.DeleteOne(), this.DeleteMany(), this.Update(), this.UpdateOne(), this.UpdateMany(), this.Count(), this.ReplaceOne(), this.Aggregate(), this.Distinct(), this.MapReduce(), this.Drop(), this.Sequence(this.Optional(this.Ident(), ((MongoDBQueryDescriptorBuilder)this.peek()).setOperationName(this.match()), new Object[0]), NativeQueryParser.ACTION((boolean)false), new Object[0])});
    }

    public Rule Find() {
        return this.Sequence("find ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.FIND), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setProjection(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule FindOne() {
        return this.Sequence("findOne ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.FINDONE), new Object[]{"( ", this.Optional(this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), new Object[0]), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setProjection(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule FindAndModify() {
        return this.Sequence("findAndModify ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.FINDANDMODIFY), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Insert() {
        return this.Sequence("insert ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.INSERT), new Object[]{"( ", this.JsonParameter(this.JsonComposite()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule InsertOne() {
        return this.Sequence("insertOne ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.INSERTONE), new Object[]{"( ", this.JsonParameter(this.JsonComposite()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule InsertMany() {
        return this.Sequence("insertMany ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.INSERTMANY), new Object[]{"( ", this.JsonParameter(this.JsonComposite()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Remove() {
        return this.Sequence("remove ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.REMOVE), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), this.Optional(this.Sequence(", ", this.FirstOf(this.Sequence(this.BooleanValue(), ((MongoDBQueryDescriptorBuilder)this.peek()).setOptions("{ 'justOne': " + this.match() + " }"), new Object[0]), this.Sequence(this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match()), new Object[0]), new Object[0]), new Object[0])), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule DeleteOne() {
        return this.Sequence("deleteOne ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.DELETEONE), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule DeleteMany() {
        return this.Sequence("deleteMany ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.DELETEMANY), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Update() {
        return this.Sequence("update ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.UPDATE), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), ", ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule UpdateOne() {
        return this.Sequence("updateOne ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.UPDATEONE), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), ", ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule UpdateMany() {
        return this.Sequence("updateMany ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.UPDATEMANY), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), ", ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule ReplaceOne() {
        return this.Sequence("replaceOne ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.REPLACEONE), new Object[]{"( ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), ", ", this.JsonParameter(this.JsonObject()), ((MongoDBQueryDescriptorBuilder)this.peek()).setUpdateOrInsert(this.match()), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Aggregate() {
        return this.Sequence("aggregate ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.AGGREGATE_PIPELINE), new Object[]{"( ", this.AggregateArray(), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule AggregateArray() {
        return this.Sequence("[ ", this.Sequence(this.AggregateObject(), this.ZeroOrMore(this.Sequence(", ", this.AggregateObject(), new Object[0])), new Object[0]), new Object[]{"] "});
    }

    public Rule AggregateObject() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()).skipNode(), "{ ", new Object[]{this.AggregatePair(), "} "});
    }

    public Rule AggregatePair() {
        return this.Sequence(this.JsonString(), ((MongoDBQueryDescriptorBuilder)this.peek()).push(this.currentIndex(), this.match()), new Object[]{": ", this.Value(), ((MongoDBQueryDescriptorBuilder)this.peek()).addPipeline(((MongoDBQueryDescriptorBuilder)this.peek()).pop(), this.match())});
    }

    public Rule Count() {
        return this.Sequence("count ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.COUNT), new Object[]{"( ", this.Optional(this.Sequence(this.JsonParameter(this.JsonComposite()), ((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match()), new Object[0])), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Distinct() {
        return this.Sequence("distinct ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.DISTINCT), new Object[]{"( ", this.Sequence(this.JsonString(), ((MongoDBQueryDescriptorBuilder)this.peek()).setDistinctFieldName(this.readStringFromJson(this.match())), new Object[0]), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setCriteria(this.match())})), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule MapReduce() {
        return this.Sequence("mapReduce ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.MAP_REDUCE), new Object[]{"( ", this.Sequence(this.JsonString(), ((MongoDBQueryDescriptorBuilder)this.peek()).setMapFunction(this.readStringFromJson(this.match())), new Object[0]), this.Sequence(", ", this.JsonString(), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setReduceFunction(this.readStringFromJson(this.match()))}), this.Optional(this.Sequence(", ", this.JsonParameter(this.JsonObject()), new Object[]{((MongoDBQueryDescriptorBuilder)this.peek()).setOptions(this.match())})), ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(true), ") "});
    }

    public Rule Drop() {
        return this.Sequence("drop ", ((MongoDBQueryDescriptorBuilder)this.peek()).setOperation(MongoDBQueryDescriptor.Operation.DROP), new Object[]{"( ", ((MongoDBQueryDescriptorBuilder)this.peek()).setParametersValid(false), ") "});
    }

    public Rule JsonParameter(Rule Parameter2) {
        return this.FirstOf(Parameter2, this.Sequence(this.ZeroOrMore(ANY), ((MongoDBQueryDescriptorBuilder)this.peek()).setInvalidJsonParameter(this.match()), new Object[]{NativeQueryParser.ACTION((boolean)false)}), new Object[0]);
    }

    public Rule JsonComposite() {
        return this.FirstOf(this.JsonObject(), this.JsonArray(), new Object[0]);
    }

    public Rule JsonObject() {
        return this.Sequence(this.ZeroOrMore(this.WhiteSpace()).skipNode(), "{ ", new Object[]{this.FirstOf(this.Sequence(this.Pair(), this.ZeroOrMore(this.Sequence(", ", this.Pair(), new Object[0])), new Object[0]), this.Optional(this.Pair()), new Object[0]).suppressNode(), "} "});
    }

    public Rule Pair() {
        return this.Sequence(this.FirstOf(this.JsonString(), this.Ident(), new Object[0]), ": ", new Object[]{this.Value()});
    }

    public Rule Value() {
        return this.FirstOf(this.PrimitiveValue(), this.JsonComposite(), new Object[]{this.BsonFunctionCall()});
    }

    public Rule PrimitiveValue() {
        return this.FirstOf(this.JsonString(), this.JsonNumber(), new Object[]{"true ", "false ", "null ", "Infinity ", "NaN ", "undefined "});
    }

    public Rule BooleanValue() {
        return this.FirstOf("true", "false", new Object[0]);
    }

    @SuppressNode
    public Rule JsonNumber() {
        return this.Sequence(this.Integer(), this.Optional(this.Sequence(this.Frac(), this.Optional(this.Exp()), new Object[0])), new Object[]{this.ZeroOrMore(this.WhiteSpace())});
    }

    public Rule JsonArray() {
        return this.Sequence("[ ", this.FirstOf(this.Sequence(this.Value(), this.ZeroOrMore(this.Sequence(", ", this.Value(), new Object[0])), new Object[0]), this.Optional(this.Value()), new Object[0]), new Object[]{"] "});
    }

    @SuppressSubnodes
    public Rule JsonString() {
        return this.FirstOf(this.JsonDoubleQuotedString(), this.JsonSingleQuotedString(), new Object[0]);
    }

    @SuppressSubnodes
    public Rule JsonDoubleQuotedString() {
        return this.Sequence("\"", this.ZeroOrMore(this.Character()), new Object[]{"\" "});
    }

    @SuppressSubnodes
    public Rule JsonSingleQuotedString() {
        return this.Sequence("'", this.ZeroOrMore(this.SingleQuotedStringCharacter()), new Object[]{"' "});
    }

    @SuppressSubnodes
    public Rule BsonFunctionCall() {
        return this.Sequence(this.Optional("new "), this.SupportedBsonFunction(), new Object[]{this.ZeroOrMore(this.WhiteSpace()), "( ", this.FirstOf(this.Sequence(this.PrimitiveValue(), this.ZeroOrMore(this.Sequence(", ", this.PrimitiveValue(), new Object[0])), new Object[0]), this.Optional(this.PrimitiveValue()), new Object[0]), ") "});
    }

    public Rule SupportedBsonFunction() {
        return this.FirstOf("BinData", "Date", new Object[]{"HexData", "ISODate", "NumberInt", "NumberLong", "ObjectId", "Timestamp", "RegExp", "DBPointer", "UUID", "GUID", "CSUUID", "CSGUID", "JUUID", "JGUID", "PYUUID", "PYGUID"});
    }

    public Rule IdentCharacter() {
        return this.FirstOf(Character.valueOf('$'), Character.valueOf('_'), new Object[]{this.CharRange('a', 'z'), this.CharRange('A', 'Z')});
    }

    public Rule Character() {
        return this.FirstOf(this.EscapedChar(), this.NormalChar(), new Object[0]);
    }

    public Rule SingleQuotedStringCharacter() {
        return this.FirstOf(this.SingleQuotedStringEscapedChar(), this.SingleQuotedStringNormalChar(), new Object[0]);
    }

    public Rule EscapedChar() {
        return this.Sequence("\\", this.FirstOf(this.AnyOf("\"\\/bfnrt"), this.Unicode(), new Object[0]), new Object[0]);
    }

    public Rule SingleQuotedStringEscapedChar() {
        return this.Sequence("\\", this.FirstOf(this.AnyOf("'\\/bfnrt"), this.Unicode(), new Object[0]), new Object[0]);
    }

    public Rule NormalChar() {
        return this.Sequence(this.TestNot(this.AnyOf("\"\\")), ANY, new Object[0]);
    }

    public Rule SingleQuotedStringNormalChar() {
        return this.Sequence(this.TestNot(this.AnyOf("'\\")), ANY, new Object[0]);
    }

    public Rule Unicode() {
        return this.Sequence("u", this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    public Rule Integer() {
        return this.Sequence(this.Optional("-"), this.FirstOf("0", this.Sequence(this.NonZeroDigit(), this.ZeroOrMore(this.Digit()), new Object[0]), new Object[0]), new Object[0]);
    }

    public Rule Digits() {
        return this.OneOrMore(this.Digit());
    }

    public Rule Digit() {
        return this.CharRange('0', '9');
    }

    public Rule NonZeroDigit() {
        return this.CharRange('1', '9');
    }

    public Rule HexDigit() {
        return this.FirstOf(this.CharRange('0', '9'), this.CharRange('a', 'f'), new Object[]{this.CharRange('A', 'F')});
    }

    public Rule Frac() {
        return this.Sequence(".", this.Digits(), new Object[0]);
    }

    public Rule Exp() {
        return this.Sequence(this.IgnoreCase("e"), this.Optional(this.AnyOf("+-")), new Object[]{this.Digits()});
    }

    @SuppressNode
    public Rule WhiteSpace() {
        return this.OneOrMore(this.AnyOf(" \n\r\t\f"));
    }

    @SuppressNode
    protected Rule fromStringLiteral(String string) {
        if (string.endsWith(" ")) {
            return this.Sequence(string.trim(), this.Optional(this.WhiteSpace()), new Object[0]);
        }
        return this.String(string);
    }

    protected String readStringFromJson(String json) {
        try (JsonReader jsonReader = new JsonReader(json);){
            String string = jsonReader.readString();
            return string;
        }
    }
}

