/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraDatastoreProvider;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraTypeMapper;
import org.hibernate.ogm.datastore.cassandra.logging.impl.Log;
import org.hibernate.ogm.datastore.cassandra.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.cassandra.model.impl.ResultSetTupleIterator;
import org.hibernate.ogm.datastore.cassandra.query.impl.CassandraParameterMetadataBuilder;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;

public class CassandraDialect
extends BaseGridDialect
implements GridDialect,
QueryableGridDialect<String> {
    private static final Log log = LoggerFactory.getLogger();
    private final CassandraDatastoreProvider provider;
    private final Session session;
    private final LoadingCache<String, PreparedStatement> preparedStatementCache;

    public CassandraDialect(CassandraDatastoreProvider provider) {
        this.provider = provider;
        this.session = provider.getSession();
        this.preparedStatementCache = CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)new CacheLoader<String, PreparedStatement>(){

            public PreparedStatement load(String query) throws Exception {
                return CassandraDialect.this.session.prepare(query);
            }
        });
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return null;
    }

    private ResultSet bindAndExecute(Object[] columnValues, RegularStatement statement) {
        PreparedStatement preparedStatement;
        try {
            preparedStatement = (PreparedStatement)this.preparedStatementCache.get((Object)statement.getQueryString());
            this.session.prepare(statement);
        }
        catch (ExecutionException e) {
            throw log.failToPrepareCQL(statement.getQueryString(), e.getCause());
        }
        try {
            BoundStatement boundStatement = new BoundStatement(preparedStatement);
            boundStatement.bind(columnValues);
            return this.session.execute((Statement)boundStatement);
        }
        catch (DriverException e) {
            throw log.failToExecuteCQL(statement.getQueryString(), (RuntimeException)((Object)e));
        }
    }

    private static String quote(String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(columnName);
        sb.append('\"');
        return sb.toString();
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Select select = QueryBuilder.select().all().from(CassandraDialect.quote(key.getTable()));
        Select.Where selectWhere = select.where(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[0]), (Object)QueryBuilder.bindMarker()));
        for (int i = 1; i < key.getColumnNames().length; ++i) {
            selectWhere = selectWhere.and(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[i]), (Object)QueryBuilder.bindMarker()));
        }
        Object[] columnValues = key.getColumnValues();
        ResultSet resultSet = this.bindAndExecute(columnValues, (RegularStatement)select);
        if (resultSet.isExhausted()) {
            return null;
        }
        Row row = resultSet.one();
        Tuple tuple = new Tuple((TupleSnapshot)new MapTupleSnapshot(CassandraDialect.tupleFromRow(row)));
        return tuple;
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        HashMap<String, Object> toSave = new HashMap<String, Object>();
        toSave.put(key.getColumnNames()[0], key.getColumnValues()[0]);
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(toSave));
    }

    /*
     * WARNING - void declaration
     */
    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) throws TupleAlreadyExistsException {
        int i;
        ArrayList<Object> updateOps = new ArrayList<Object>(tuple.getOperations().size());
        ArrayList<Object> deleteOps = new ArrayList<Object>(tuple.getOperations().size());
        block4: for (Object op : tuple.getOperations()) {
            switch (op.getType()) {
                case PUT: {
                    updateOps.add(op);
                    continue block4;
                }
                case REMOVE: 
                case PUT_NULL: {
                    deleteOps.add(op);
                    continue block4;
                }
            }
            throw new HibernateException("TupleOperation not supported: " + op.getType());
        }
        if (deleteOps.size() > 0) {
            Delete.Selection deleteSelection = QueryBuilder.delete();
            for (TupleOperation tupleOperation : deleteOps) {
                deleteSelection.column(CassandraDialect.quote(tupleOperation.getColumn()));
            }
            Delete delete = deleteSelection.from(CassandraDialect.quote(key.getTable()));
            Delete.Where where = delete.where(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[0]), (Object)QueryBuilder.bindMarker()));
            for (i = 1; i < key.getColumnNames().length; ++i) {
                void var8_10;
                Delete.Where where2 = var8_10.and(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[i]), (Object)QueryBuilder.bindMarker()));
            }
            this.bindAndExecute(key.getColumnValues(), (RegularStatement)delete);
        }
        if (updateOps.size() > 0) {
            Insert insert = QueryBuilder.insertInto((String)CassandraDialect.quote(key.getTable()));
            LinkedList<Object> columnValues = new LinkedList<Object>();
            HashSet<String> hashSet = new HashSet<String>();
            for (i = 0; i < updateOps.size(); ++i) {
                TupleOperation op = (TupleOperation)updateOps.get(i);
                insert.value(CassandraDialect.quote(op.getColumn()), (Object)QueryBuilder.bindMarker());
                columnValues.add(op.getValue());
                hashSet.add(op.getColumn());
            }
            for (int j = 0; j < key.getColumnNames().length; ++j) {
                String keyCol = key.getColumnNames()[j];
                if (hashSet.contains(keyCol)) continue;
                insert.value(CassandraDialect.quote(keyCol), (Object)QueryBuilder.bindMarker());
                columnValues.add(key.getColumnValues()[j]);
            }
            this.bindAndExecute(columnValues.toArray(), (RegularStatement)insert);
        }
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        Delete delete = QueryBuilder.delete().from(CassandraDialect.quote(key.getTable()));
        Delete.Where deleteWhere = delete.where(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[0]), (Object)QueryBuilder.bindMarker()));
        for (int i = 1; i < key.getColumnNames().length; ++i) {
            deleteWhere = deleteWhere.and(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[i]), (Object)QueryBuilder.bindMarker()));
        }
        this.bindAndExecute(key.getColumnValues(), (RegularStatement)delete);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Object[] columnValues;
        ResultSet resultSet;
        Table tableMetadata = this.provider.getMetaDataCache().get(key.getTable());
        List tablePKCols = tableMetadata.getPrimaryKey().getColumns();
        Select select = QueryBuilder.select().all().from(CassandraDialect.quote(key.getTable()));
        Select.Where selectWhere = select.where(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[0]), (Object)QueryBuilder.bindMarker()));
        for (int i = 1; i < key.getColumnNames().length; ++i) {
            selectWhere = selectWhere.and(QueryBuilder.eq((String)CassandraDialect.quote(key.getColumnNames()[i]), (Object)QueryBuilder.bindMarker()));
        }
        boolean requiredFiltering = false;
        for (Column column : tablePKCols) {
            String name = column.getName();
            boolean foundColumn = false;
            for (int i = 0; i < key.getColumnNames().length; ++i) {
                if (!name.equals(key.getColumnNames()[i])) continue;
                foundColumn = true;
                break;
            }
            if (foundColumn) continue;
            requiredFiltering = true;
            break;
        }
        if (requiredFiltering) {
            select.allowFiltering();
        }
        if ((resultSet = this.bindAndExecute(columnValues = key.getColumnValues(), (RegularStatement)select)).isExhausted()) {
            return null;
        }
        HashMap<RowKey, Map<String, Object>> rowKeyMap = new HashMap<RowKey, Map<String, Object>>();
        LinkedList<String> combinedKeys = new LinkedList<String>();
        combinedKeys.addAll(Arrays.asList(key.getColumnNames()));
        for (Object column : tableMetadata.getPrimaryKey().getColumns()) {
            String name = ((Column)column).getName();
            if (combinedKeys.contains(name)) continue;
            combinedKeys.add(name);
        }
        String[] columnNames = combinedKeys.toArray(new String[combinedKeys.size()]);
        for (Row row : resultSet) {
            Map<String, Object> rowMap = CassandraDialect.tupleFromRow(row);
            Object[] resultColumnValues = new Object[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                resultColumnValues[i] = rowMap.get(columnNames[i]);
            }
            RowKey rowKey = new RowKey(columnNames, resultColumnValues);
            rowKeyMap.put(rowKey, rowMap);
        }
        Association association = new Association((AssociationSnapshot)new MapAssociationSnapshot(rowKeyMap));
        return association;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(new HashMap()));
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        Tuple value;
        if (key.getMetadata().isInverse()) {
            return;
        }
        Table tableMetadata = this.provider.getMetaDataCache().get(key.getTable());
        HashSet<String> keyColumnNames = new HashSet<String>();
        for (Object columnObject : tableMetadata.getPrimaryKey().getColumns()) {
            Column column = (Column)columnObject;
            keyColumnNames.add(column.getName());
        }
        ArrayList<AssociationOperation> updateOps = new ArrayList<AssociationOperation>(association.getOperations().size());
        ArrayList<AssociationOperation> deleteOps = new ArrayList<AssociationOperation>(association.getOperations().size());
        block6: for (AssociationOperation op : association.getOperations()) {
            switch (op.getType()) {
                case CLEAR: {
                    continue block6;
                }
                case PUT: {
                    updateOps.add(op);
                    continue block6;
                }
                case REMOVE: {
                    deleteOps.add(op);
                    continue block6;
                }
            }
            throw new HibernateException("AssociationOperation not supported: " + op.getType());
        }
        for (AssociationOperation op : updateOps) {
            value = op.getValue();
            ArrayList<Object> columnValues = new ArrayList<Object>();
            String[] insert = QueryBuilder.insertInto((String)CassandraDialect.quote(key.getTable()));
            for (String columnName : value.getColumnNames()) {
                insert.value(CassandraDialect.quote(columnName), (Object)QueryBuilder.bindMarker((String)columnName));
                columnValues.add(value.get(columnName));
            }
            this.bindAndExecute(columnValues.toArray(), (RegularStatement)insert);
        }
        for (AssociationOperation op : deleteOps) {
            value = op.getKey();
            Delete.Selection deleteSelection = QueryBuilder.delete();
            for (String columnName : op.getKey().getColumnNames()) {
                if (keyColumnNames.contains(columnName)) continue;
                deleteSelection.column(CassandraDialect.quote(columnName));
            }
            Delete delete = deleteSelection.from(CassandraDialect.quote(key.getTable()));
            LinkedList<Object> columnValues = new LinkedList<Object>();
            for (String columnName : value.getColumnNames()) {
                if (!keyColumnNames.contains(columnName)) continue;
                delete.where(QueryBuilder.eq((String)CassandraDialect.quote(columnName), (Object)QueryBuilder.bindMarker((String)columnName)));
                columnValues.add(value.getColumnValue(columnName));
            }
            this.bindAndExecute(columnValues.toArray(), (RegularStatement)delete);
        }
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        Table tableMetadata = this.provider.getMetaDataCache().get(key.getTable());
        HashSet<String> keyColumnNames = new HashSet<String>();
        for (Object e : tableMetadata.getPrimaryKey().getColumns()) {
            Column column = (Column)e;
            keyColumnNames.add(column.getName());
        }
        Delete.Selection deleteSelection = QueryBuilder.delete();
        for (String string : key.getColumnNames()) {
            if (keyColumnNames.contains(string)) continue;
            deleteSelection.column(CassandraDialect.quote(string));
        }
        Delete delete = deleteSelection.from(CassandraDialect.quote(key.getTable()));
        LinkedList<Object> columnValues = new LinkedList<Object>();
        boolean hasWhereClause = false;
        for (String columnName : key.getColumnNames()) {
            if (!keyColumnNames.contains(columnName)) continue;
            delete.where(QueryBuilder.eq((String)CassandraDialect.quote(columnName), (Object)QueryBuilder.bindMarker((String)columnName)));
            columnValues.add(key.getColumnValue(columnName));
            hasWhereClause = true;
        }
        if (!hasWhereClause) {
            return;
        }
        this.bindAndExecute(columnValues.toArray(), (RegularStatement)delete);
    }

    public GridType overrideType(Type type) {
        return CassandraTypeMapper.INSTANCE.overrideType(type);
    }

    public void forEachTuple(ModelConsumer consumer, TupleContext tupleContext, EntityKeyMetadata entityKeyMetadata) {
        Select select = QueryBuilder.select().all().from(CassandraDialect.quote(entityKeyMetadata.getTable()));
        ResultSet resultSet = this.session.execute((Statement)select);
        for (Row row : resultSet) {
            consumer.consume(new Tuple((TupleSnapshot)new MapTupleSnapshot(CassandraDialect.tupleFromRow(row))));
        }
    }

    public static Map<String, Object> tupleFromRow(Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        int count = columnDefinitions.size();
        for (int index = 0; index < count; ++index) {
            String columnName = columnDefinitions.getName(index);
            Object value = row.getObject(index);
            map.put(columnName, value);
        }
        return map;
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.provider.getSequenceHandler().nextValue(request);
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> query, QueryParameters queryParameters) {
        Object[] parameters = new Object[queryParameters.getPositionalParameters().size()];
        int i = 0;
        Tuple dummy = new Tuple();
        for (TypedGridValue parameter : queryParameters.getPositionalParameters()) {
            parameter.getType().nullSafeSet(dummy, parameter.getValue(), new String[]{"dummy"}, null);
            parameters[i] = dummy.get("dummy");
            ++i;
        }
        ResultSet resultSet = this.bindAndExecute(parameters, (RegularStatement)new SimpleStatement((String)query.getQuery()));
        int first = 0;
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            first = queryParameters.getRowSelection().getFirstRow();
        }
        int max = Integer.MAX_VALUE;
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            max = queryParameters.getRowSelection().getMaxRows();
        }
        return new ResultSetTupleIterator(resultSet, first, max);
    }

    public int executeBackendUpdateQuery(BackendQuery<String> query, QueryParameters queryParameters) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return new CassandraParameterMetadataBuilder(this.session, this.provider.getMetaDataCache());
    }

    public String parseNativeQuery(String nativeQuery) {
        return nativeQuery;
    }
}

